package com.github.tartaricacid.touhoulittlemaid.debug.target;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5996;
import net.minecraft.server.MinecraftServer;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

/**
 * 管理调试数据
 */
@class_5996
public class DebugMaidManager {
    public static ConcurrentHashMap<UUID, Set<UUID>> PLAYER_DEBUGGING_MAID = new ConcurrentHashMap<>();
    public static ConcurrentHashMap<UUID, Set<UUID>> MAID_DEBUGGING_PLAYER = new ConcurrentHashMap<>();
    public static List<Function<EntityMaid, List<DebugTarget>>> DEBUG_TARGETS = new ArrayList<>();

    public static void init() {
        DEBUG_TARGETS.addAll(DefaultTargets.getDefaultTargets());
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            DEBUG_TARGETS.addAll(littleMaid.getMaidDebugTargets());
        }
    }

    /**
     * 获取女仆的所有调试目标
     *
     * @param maid 女仆
     * @return 调试目标列表
     */
    public static List<DebugTarget> getDebugTargets(EntityMaid maid) {
        return DEBUG_TARGETS.stream().flatMap(f -> f.apply(maid).stream()).toList();
    }

    /**
     * 根据女仆获取调试该女仆的玩家
     *
     * @param maid 女仆
     * @return 玩家列表
     */
    public static List<class_3222> getDebuggingPlayer(EntityMaid maid) {
        Set<UUID> playerId = MAID_DEBUGGING_PLAYER.get(maid.method_5667());
        if (playerId == null) {
            return List.of();
        }
        MinecraftServer server = maid.field_6002.method_8503();
        if (server == null) {
            return List.of();
        }
        return playerId.stream()
                .map(uuid -> server.method_3760().method_14602(uuid))
                .filter(Objects::nonNull).toList();
    }

    /**
     * 根据玩家获取正在调试该玩家的女仆
     *
     * @param player 玩家
     * @return 女仆列表
     */
    public static List<EntityMaid> getDebuggingMaid(class_3222 player) {
        Set<UUID> maidId = PLAYER_DEBUGGING_MAID.get(player.method_5667());
        if (maidId == null) {
            return List.of();
        }
        return maidId.stream()
                .map(uuid -> player.method_51469().method_14190(uuid))
                .filter(Objects::nonNull)
                .filter(EntityMaid.class::isInstance)
                .map(EntityMaid.class::cast).toList();
    }

    /**
     * 设置正在调试的女仆
     *
     * @param player 玩家
     * @param maid   女仆
     */
    public static void setDebuggingMaid(class_3222 player, EntityMaid maid) {
        removeDebuggingMaid(player, maid);
        PLAYER_DEBUGGING_MAID.computeIfAbsent(player.method_5667(), k -> new HashSet<>()).add(maid.method_5667());
        MAID_DEBUGGING_PLAYER.computeIfAbsent(maid.method_5667(), k -> new HashSet<>()).add(player.method_5667());
    }

    /**
     * 移除正在调试的女仆
     *
     * @param player 玩家
     * @param maid   女仆
     */
    public static void removeDebuggingMaid(class_3222 player, EntityMaid maid) {
        if (PLAYER_DEBUGGING_MAID.containsKey(player.method_5667())) {
            PLAYER_DEBUGGING_MAID.get(player.method_5667()).remove(maid.method_5667());
        }
        if (MAID_DEBUGGING_PLAYER.containsKey(maid.method_5667())) {
            MAID_DEBUGGING_PLAYER.get(maid.method_5667()).remove(player.method_5667());
        }
    }

    /**
     * 切换该女仆的调试状态
     *
     * @param player 玩家
     * @param maid   女仆
     */
    public static void triggerDebuggingMaid(class_3222 player, EntityMaid maid) {
        if (PLAYER_DEBUGGING_MAID.containsKey(player.method_5667()) && PLAYER_DEBUGGING_MAID.get(player.method_5667()).contains(maid.method_5667())) {
            removeDebuggingMaid(player, maid);
            player.method_43496(class_2561.method_43471("debug.touhou_little_maid.debug_stick.show_path_finder.disable"));
        } else {
            setDebuggingMaid(player, maid);
            player.method_43496(class_2561.method_43471("debug.touhou_little_maid.debug_stick.show_path_finder.enable"));
        }
    }
}