package com.github.tartaricacid.touhoulittlemaid.debug.target;

import cn.sh1rocu.touhoulittlemaid.api.event.PlayerTickEvent;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import javax.annotation.Nullable;
import net.minecraft.class_11;
import net.minecraft.class_2658;
import net.minecraft.class_3222;
import net.minecraft.class_5996;
import net.minecraft.class_8714;
import net.minecraft.class_8721;
import java.util.List;

@class_5996
public class SendMaidDebugDataEvent {
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        if (!TouhouLittleMaid.DEBUG) {
            return;
        }
        if (event.getEntity().field_6002.field_9236 || !(event.getEntity() instanceof class_3222 serverPlayer)) {
            return;
        }
        // 每 4 tick 发送一次数据
        if (serverPlayer.field_6012 % 4 == 0) {
            List<EntityMaid> debuggingMaid = DebugMaidManager.getDebuggingMaid(serverPlayer);
            for (EntityMaid maid : debuggingMaid) {
                renderForMaid(maid, serverPlayer);
            }
        }
    }

    private static void renderForMaid(@Nullable EntityMaid maid, class_3222 player) {
        if (maid == null) {
            return;
        }

        if (!maid.method_5942().method_6357()) {
            class_11 path = maid.method_5942().method_6345();
            if (path != null) {
                player.field_13987.method_14364(new class_2658(new class_8721(maid.method_5628(), path, 0.5f)));
            }
        }

        DebugMaidManager.getDebugTargets(maid).forEach(target -> {
            class_8714 payload = new class_8714(
                    target.pos(), target.color(), target.text(), target.lifeTime());
            player.field_13987.method_14364(new class_2658(payload));
        });
    }
}