package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.google.common.collect.ImmutableMap;
import net.minecraft.class_1292;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;

/**
 * 女仆从离开呼吸的任务返回
 */
public class MaidBreathAirStopTask extends class_4097<EntityMaid> {
    public MaidBreathAirStopTask() {
        super(ImmutableMap.of());
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 level, EntityMaid maid) {
        if (!maid.getSwimManager().isGoingToBreath()) {
            return false;
        }
        // 下面的条件表示女仆不再有窒息风险
        if (maid.method_5669() >= 290) {
            return true;
        }
        if (class_1292.method_5574(maid)) {
            return true;
        }
        if (hasDrownBauble(maid)) {
            return true;
        }
        return false;
    }

    @Override
    protected void start(class_3218 level, EntityMaid maid, long gameTime) {
        maid.getSwimManager().setGoingToBreath(false);
        // 如果呼吸计划打断了某些任务寻路，则需要重置目标记忆来重新寻路
        maid.method_18868().method_18875(class_4140.field_18445);
        maid.method_18868().method_18875(InitEntities.TARGET_POS);
    }

    private boolean hasDrownBauble(EntityMaid maid) {
        BaubleItemHandler maidBauble = maid.getMaidBauble();
        for (int i = 0; i < maidBauble.getSlots(); i++) {
            if (maidBauble.getStackInSlot(i).method_31574(InitItems.DROWN_PROTECT_BAUBLE)) {
                return true;
            }
        }
        return false;
    }
}
