package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.util.TeleportHelper;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_4215;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public final class SchedulePos {
    private static final int MAX_TELEPORT_ATTEMPTS_TIMES = 10;

    private class_2338 workPos;
    private class_2338 idlePos;
    private class_2338 sleepPos;
    private class_2960 dimension;
    private boolean configured = false;

    public static final class_9139<class_9129, SchedulePos> SCHEDULE_POS_STREAM_CODEC = class_9139.method_56905(
            class_2338.field_48404, SchedulePos::getWorkPos,
            class_2338.field_48404, SchedulePos::getIdlePos,
            class_2338.field_48404, SchedulePos::getSleepPos,
            class_2960.field_48267, SchedulePos::getDimension,
            SchedulePos::new
    );

    public SchedulePos(class_2338 workPos, class_2338 idlePos, class_2338 sleepPos, class_2960 dimension) {
        this.workPos = workPos;
        this.idlePos = idlePos;
        this.sleepPos = sleepPos;
        this.dimension = dimension;
    }

    public SchedulePos(class_2338 workPos, class_2338 idlePos, class_2960 dimension) {
        this(workPos, idlePos, idlePos, dimension);
    }

    public SchedulePos(class_2338 workPos, class_2960 dimension) {
        this(workPos, workPos, dimension);
    }

    public void setWorkPos(class_2338 workPos) {
        this.workPos = workPos;
    }

    public void setIdlePos(class_2338 idlePos) {
        this.idlePos = idlePos;
    }

    public void setSleepPos(class_2338 sleepPos) {
        this.sleepPos = sleepPos;
    }

    public void setDimension(class_2960 dimension) {
        this.dimension = dimension;
    }

    public void tick(EntityMaid maid) {
        if (maid.field_6012 % 40 == 0) {
            this.restrictTo(maid);
            if (maid.method_18411()) {
                return;
            }
            if (!maid.canBrainMoving()) {
                return;
            }
            double distanceSqr = maid.method_18412().method_10262(maid.method_24515());
            int minTeleportDistance = (int) maid.method_18413() + 4;
            if (distanceSqr > (minTeleportDistance * minTeleportDistance) && !this.sameWithRestrictCenter(maid)) {
                teleport(maid);
            } else {
                class_4215.method_24561(maid, maid.method_18412(), 0.7f, 3);
            }
        }
    }

    public void save(class_2487 compound) {
        class_2487 data = new class_2487();
        data.method_10566("Work", class_2512.method_10692(this.workPos));
        data.method_10566("Idle", class_2512.method_10692(this.idlePos));
        data.method_10566("Sleep", class_2512.method_10692(this.sleepPos));
        data.method_10582("Dimension", this.dimension.toString());
        data.method_10556("Configured", this.configured);
        compound.method_10566("MaidSchedulePos", data);
    }

    public void load(class_2487 compound, EntityMaid maid) {
        if (compound.method_10573("MaidSchedulePos", class_2520.field_33260)) {
            class_2487 data = compound.method_10562("MaidSchedulePos");
            this.workPos = class_2512.method_10691(data, "Work").orElse(null);
            this.idlePos = class_2512.method_10691(data, "Idle").orElse(null);
            this.sleepPos = class_2512.method_10691(data, "Sleep").orElse(null);
            this.dimension = class_2960.method_60654(data.method_10558("Dimension"));
            this.configured = data.method_10577("Configured");
            this.restrictTo(maid);
        }
    }

    public void restrictTo(EntityMaid maid) {
        if (!maid.isHomeModeEnable()) {
            return;
        }
        class_4168 activity = maid.getScheduleDetail();
        if (activity == class_4168.field_18596) {
            maid.method_18408(this.workPos, MaidConfig.MAID_WORK_RANGE.get());
            return;
        }
        if (activity == class_4168.field_18595) {
            maid.method_18408(this.idlePos, MaidConfig.MAID_IDLE_RANGE.get());
            return;
        }
        if (activity == class_4168.field_18597) {
            maid.method_18408(this.sleepPos, MaidConfig.MAID_SLEEP_RANGE.get());
        }
    }

    public void setConfigured(boolean configured) {
        this.configured = configured;
    }

    public class_2338 getWorkPos() {
        return workPos;
    }

    public class_2338 getIdlePos() {
        return idlePos;
    }

    public class_2338 getSleepPos() {
        return sleepPos;
    }

    public boolean isConfigured() {
        return configured;
    }

    public class_2960 getDimension() {
        return dimension;
    }

    public void clear(EntityMaid maid) {
        this.idlePos = this.workPos;
        this.sleepPos = this.workPos;
        this.configured = false;
        this.dimension = maid.field_6002.method_27983().method_29177();
        this.restrictTo(maid);
    }

    public void setHomeModeEnable(EntityMaid maid, class_2338 pos) {
        if (!this.configured) {
            this.workPos = pos;
            this.idlePos = pos;
            this.sleepPos = pos;
            this.dimension = maid.field_6002.method_27983().method_29177();
        }
        this.restrictTo(maid);
    }

    @Nullable
    public class_2338 getNearestPos(EntityMaid maid) {
        if (this.configured) {
            class_2338 pos = this.workPos;
            double workDistance = maid.method_24515().method_10262(this.workPos);
            double idleDistance = maid.method_24515().method_10262(this.idlePos);
            double sleepDistance = maid.method_24515().method_10262(this.sleepPos);
            if (workDistance > idleDistance) {
                pos = this.idlePos;
                workDistance = idleDistance;
            }
            if (workDistance > sleepDistance) {
                pos = this.sleepPos;
            }
            return pos;
        }
        return null;
    }

    private boolean sameWithRestrictCenter(EntityMaid maid) {
        class_2338 restrictCenter = maid.method_18412();
        return maid.method_18868().method_18904(class_4140.field_18445)
                .filter(walkTarget -> walkTarget.method_19094().method_18989().equals(restrictCenter))
                .isPresent();
    }

    private void teleport(EntityMaid maid) {
        for (int i = 0; i < MAX_TELEPORT_ATTEMPTS_TIMES; ++i) {
            if (TeleportHelper.teleportToRestrictCenter(maid)) {
                return;
            }
        }
    }
}
