package com.github.tartaricacid.touhoulittlemaid.event;

import cn.sh1rocu.touhoulittlemaid.api.event.EntityJoinLevelEvent;
import cn.sh1rocu.touhoulittlemaid.mixin.accessor.MobAccessor;
import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.goal.MaidTemptGoal;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncDataPackage;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1338;
import net.minecraft.class_1355;
import net.minecraft.class_1391;
import net.minecraft.class_1429;
import net.minecraft.class_1548;
import net.minecraft.class_3222;
import java.util.List;

import static com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment.POWER_NUM;

public class EntityJoinWorldEvent {
    public static void onCreeperJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof class_1548 creeper) {
            ((MobAccessor) creeper).tlm$goalSelector().method_6277(1, new class_1338<>(creeper, EntityMaid.class, 6, 1, 1.2));
        }
    }

    public static void onAnimalJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof class_1429 animal) {
            class_1355 goalSelector = ((MobAccessor) animal).tlm$goalSelector();
            // 先复制一遍进行遍历，避免出现 ConcurrentModificationException
            var goals = List.copyOf(goalSelector.method_35115());
            goals.stream().filter(goal -> goal.method_19058() instanceof class_1391).findFirst().ifPresent(g -> {
                if (g.method_19058() instanceof class_1391 temptGoal) {
                    MaidTemptGoal maidTemptGoal = new MaidTemptGoal(temptGoal.field_6616, temptGoal.field_6615, temptGoal.field_6622, temptGoal.field_6620);
                    goalSelector.method_6277(g.method_19057(), maidTemptGoal);
                }
            });
        }
    }

    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof class_3222 player) {
            PowerAttachment power = player.getAttachedOrCreate(POWER_NUM, () -> new PowerAttachment(0));
            MaidNumAttachment maidNum = player.getAttachedOrCreate(InitDataAttachment.MAID_NUM, () -> new MaidNumAttachment(0));
            ServerPlayNetworking.send(player, new SyncDataPackage(power.get(), maidNum.get()));
        }
    }
}