package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.context.IContext;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.function.entity.EntityFunction;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.MolangUtils;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.ExecutionContext;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class RelativeBlockHasAllTags extends EntityFunction {
    @Override
    protected Object eval(ExecutionContext<IContext<class_1297>> ctx, ArgumentCollection arguments) {
        class_1297 entity = ctx.entity().entity();

        int offsetX = arguments.getAsInt(ctx, 0);
        int offsetY = arguments.getAsInt(ctx, 1);
        int offsetZ = arguments.getAsInt(ctx, 2);
        if (Math.abs(offsetX) > 8 || Math.abs(offsetY) > 8 || Math.abs(offsetZ) > 8) {
            return false;
        }

        class_2680 block = ctx.entity().entity().method_37908().method_8320(entity.method_24515());

        for (int i = 3; i < arguments.size(); i++) {
            class_2960 tagId = MolangUtils.parseResourceLocation(ctx.entity(), arguments.getAsString(ctx, i));
            if (tagId == null) {
                return null;
            }

            class_6862<class_2248> tag = class_6862.method_40092(class_7924.field_41254, tagId);
            if (!block.method_26164(tag)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean validateArgumentSize(int size) {
        return size >= 4;
    }
}
