package com.github.tartaricacid.touhoulittlemaid.mixin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1764;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1764.class)
public class MixinCrossbowItem {
    @Inject(method = "shootProjectile(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/projectile/Projectile;IFFFLnet/minecraft/world/entity/LivingEntity;)V", at = @At("HEAD"), cancellable = true)
    protected void shootProjectile(class_1309 shooter, class_1676 projectile, int index, float velocity, float inaccuracy, float angle, class_1309 target, CallbackInfo ci) {
        if (shooter instanceof EntityMaid maid) {
            // 弩箭伤害也和好感度挂钩
            // 但是烟花火箭的伤害是很特殊的，就不应用了
            if (projectile instanceof class_1665 arrow) {
                class_1324 attackDamage = maid.method_5996(class_5134.field_23721);
                double attackValue = 2.0;
                if (attackDamage != null) {
                    attackValue = attackDamage.method_6201();
                }
                float multiplier = (float) (attackValue / 2.0f);
                arrow.method_7438(arrow.method_7448() * multiplier);
            }
            this.shootCrossbowProjectile(shooter, target, projectile, 1.6F);
            ci.cancel();
        }
    }

    /**
     * 修改默认方法，让女仆能实现超远距离打击
     */
    @Unique
    private void shootCrossbowProjectile(class_1309 shooter, class_1309 target, class_1676 projectile, float velocityIn) {
        double x = target.method_23317() - shooter.method_23317();
        double y = target.method_23320() - shooter.method_23320();
        double z = target.method_23321() - shooter.method_23321();
        // 依据距离调整箭速和不准确度
        float distance = shooter.method_5739(target);
        float velocity = class_3532.method_15363(distance / 10f, velocityIn, 3.2f);
        float inaccuracy = 1 - class_3532.method_15363(distance / 100f, 0, 0.9f);
        // 射出的箭忽略重力，从而能让女仆百发百中
        projectile.method_5875(true);
        projectile.method_7485(x, y, z, velocity, inaccuracy);
        shooter.method_5783(class_3417.field_15187, 1.0F, 1.0F / (shooter.method_59922().method_43057() * 0.4F + 0.8F));
    }
}