package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBroom;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record DismountPackage(int action) implements class_8710 {
    public static final int DISMOUNT_BROOM = 1;
    public static final class_8710.class_9154<DismountPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("dismount"));
    public static final class_9139<class_9129, DismountPackage> STREAM_CODEC = class_9139.method_56434(
            class_9135.field_48550, DismountPackage::action,
            DismountPackage::new
    );

    public static void handle(DismountPackage message, ServerPlayNetworking.Context context) {
        class_3222 sender = context.player();
        context.server().execute(() -> onHandle(message, sender));
    }

    private static void onHandle(DismountPackage message, class_3222 sender) {
        // 处理卸载扫帚的逻辑
        if (message.action() == DISMOUNT_BROOM && sender.method_5854() instanceof EntityBroom) {
            sender.method_5848();
        }
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}