package cn.sh1rocu.touhoulittlemaid.mixin.common;

import cn.sh1rocu.touhoulittlemaid.api.extension.IRedstoneConnect;
import net.minecraft.class_2350;
import net.minecraft.class_2457;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

/**
 * From Porting_Lib
 */
@Mixin(class_2457.class)
public class RedStoneWireBlockMixin {
    @Inject(
            method = "shouldConnectTo(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;)Z",
            at = @At("HEAD"),
            cancellable = true
    )
    private static void tlm$shouldConnectTo(class_2680 state, class_2350 side, CallbackInfoReturnable<Boolean> cir) {
        if (state.method_26204() instanceof IRedstoneConnect connect) {
            // Passing null for world and pos here just for extra upstream compat, not properly implementing it because
            // 1. world and pos are never used in Create
            // 2. extra work :help_me:
            cir.setReturnValue(connect.canConnectRedstone(state, null, null, side));
        }
    }
}