package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.sound.data.MaidSoundInstance;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.netty.buffer.ByteBuf;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record PlayMaidSoundPackage(class_2960 soundEvent, String id,
                                   int entityId) implements class_8710 {
    public static final class_8710.class_9154<PlayMaidSoundPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("play_maid_sound"));
    public static final class_9139<ByteBuf, PlayMaidSoundPackage> STREAM_CODEC = class_9139.method_56436(
            class_2960.field_48267,
            PlayMaidSoundPackage::soundEvent,
            class_9135.field_48554,
            PlayMaidSoundPackage::id,
            class_9135.field_48550,
            PlayMaidSoundPackage::entityId,
            PlayMaidSoundPackage::new
    );

    public static void handle(PlayMaidSoundPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> playSound(message));
    }

    @Environment(EnvType.CLIENT)
    private static void playSound(PlayMaidSoundPackage message) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null) {
            class_1297 entity = mc.field_1687.method_8469(message.entityId);
            if (entity instanceof EntityMaid maid) {
                class_3414 event = class_7923.field_41172.method_10223(message.soundEvent);
                if (event != null) {
                    mc.method_1483().method_4873(new MaidSoundInstance(event, message.id, maid));

                }
            }
        }
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
