package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.awt.*;
import net.minecraft.class_1308;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5599;

public class LayerMaidBackpack extends class_3887<class_1308, BedrockModel<class_1308>> {
    private final EntityMaidRenderer renderer;

    public LayerMaidBackpack(EntityMaidRenderer renderer, class_5599 modelSet) {
        super(renderer);
        this.renderer = renderer;
        BackpackManager.initClient(modelSet);
    }

    @Override
    public void render(class_4587 poseStack, class_4597 bufferIn, int packedLightIn, class_1308 mob, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        EntityMaid maid = IMaid.convertToMaid(mob);
        if (maid == null) {
            return;
        }
        if (!renderer.getMainInfo().isShowBackpack() || mob.method_6113() || mob.method_5767()) {
            return;
        }
        // 稍微缩放，避免整数倍的 z-flight
        poseStack.method_22905(1.01f, 1.01f, 1.01f);
        // [-13, 41, 15]
        if (method_17165().hasBackpackPositioningModel()) {
            BedrockPart renderer = method_17165().getBackpackPositioningModel();
            poseStack.method_22904(renderer.x * 0.0625, 0.0625 * (renderer.y - 23 + 8), 0.0625 * (renderer.z + 4));
        } else {
            poseStack.method_22904(0, -0.5, 0.25);
        }
        IMaidBackpack type = maid.getConfigManager().isShowBackpack() ? maid.getMaidBackpackType() : BackpackManager.getEmptyBackpack();
        BackpackManager.findBackpackModel(type.getId()).ifPresent(pair -> method_23199(pair.getLeft(), pair.getRight(), poseStack, bufferIn, packedLightIn, maid, new Color(1.0f, 1.0f, 1.0f).getRGB()));
    }
}
