package com.github.tartaricacid.touhoulittlemaid.mixin.client;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_5272;
import net.minecraft.class_638;

@Mixin(class_5272.class)
public class ItemPropertiesMixin {
    @SuppressWarnings("target")
    @Inject(method = "method_27883", at = @At("HEAD"), cancellable = true)
    private static void onItemRender(class_1799 stack, @Nullable class_638 pLevel, @Nullable class_1309 entity, int pSeed, CallbackInfoReturnable<Float> ci) {
        if (entity instanceof EntityMaid maid && maid.method_6047() == stack) {
            float result = maid.hasFishingHook() ? 1.0F : 0.0F;
            ci.setReturnValue(result);
        }
    }
}
