/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.texture;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class ZipPackTexture
extends SizeTexture {
    private final class_2960 texturePath;
    private final Path zipFilePath;
    private int width = 16;
    private int height = 16;

    public ZipPackTexture(String zipFilePath, class_2960 texturePath) {
        this.zipFilePath = Paths.get(zipFilePath, new String[0]);
        this.texturePath = texturePath;
    }

    @Override
    public boolean isExist() {
        boolean bl;
        ZipFile zipFile = new ZipFile(this.zipFilePath.toFile());
        try {
            ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", this.texturePath.method_12836(), this.texturePath.method_12832()));
            bl = entry != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        zipFile.close();
        return bl;
    }

    public void method_4625(class_3300 manager) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::doLoad);
        } else {
            this.doLoad();
        }
    }

    private void doLoad() {
        try (ZipFile zipFile = new ZipFile(this.zipFilePath.toFile());){
            ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", this.texturePath.method_12836(), this.texturePath.method_12832()));
            if (entry == null) {
                return;
            }
            try (InputStream stream = zipFile.getInputStream(entry);){
                class_1011 imageIn = class_1011.method_4309((InputStream)stream);
                this.width = imageIn.method_4307();
                this.height = imageIn.method_4323();
                TextureUtil.prepareImage((int)this.method_4624(), (int)0, (int)this.width, (int)this.height);
                imageIn.method_22619(0, 0, 0, 0, 0, this.width, this.height, false, false, false, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

