/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.RangedWrapper;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticlePackage;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4142;
import net.minecraft.class_4174;
import net.minecraft.class_4215;
import net.minecraft.class_8;
import net.minecraft.class_9334;

public class MaidBreathAirTask
extends class_4097<EntityMaid> {
    private static final int MAX_PROBABILITY = 5;
    private static final int AIR_SEARCH_RANGE = 16;

    public MaidBreathAirTask() {
        super((Map)ImmutableMap.of());
    }

    protected boolean checkExtraStartConditions(class_3218 level, EntityMaid maid) {
        class_2338 target;
        if (maid.getSwimManager().isEatBreatheItem()) {
            return false;
        }
        if (maid.getSwimManager().isGoingToBreath() && maid.method_18868().method_18896(class_4140.field_18445) && this.givesAir(maid, target = ((class_4142)maid.method_18868().method_18904(class_4140.field_18445).get()).method_19094().method_18989()) && (!maid.method_5942().method_6357() || maid.method_24515().method_19455((class_2382)target) <= 1)) {
            return false;
        }
        if (maid.method_5669() >= 100) {
            return false;
        }
        if (class_1292.method_5574((class_1309)maid)) {
            return false;
        }
        if (this.hasDrownBauble(maid)) {
            return false;
        }
        return !maid.method_6115();
    }

    protected void start(class_3218 level, EntityMaid maid, long gameTime) {
        if (this.eatBreatheItem(maid)) {
            return;
        }
        this.findAirPosition(level, maid);
    }

    private boolean hasDrownBauble(EntityMaid maid) {
        BaubleItemHandler maidBauble = maid.getMaidBauble();
        for (int i = 0; i < maidBauble.getSlots(); ++i) {
            if (!maidBauble.getStackInSlot(i).method_31574(InitItems.DROWN_PROTECT_BAUBLE)) continue;
            return true;
        }
        return false;
    }

    private boolean eatBreatheItem(EntityMaid maid) {
        for (class_1268 hand : class_1268.values()) {
            class_1799 itemInHand = maid.method_5998(hand);
            if (itemInHand.method_7960() || !this.isBreatheFood(maid, itemInHand)) continue;
            this.startEatBreatheItem(maid, itemInHand, hand);
            return true;
        }
        class_1268 eanHand = class_1268.field_5810;
        for (class_1268 hand : class_1268.values()) {
            if (!maid.method_5998(hand).method_7960()) continue;
            eanHand = hand;
            break;
        }
        class_1799 itemInHand = maid.method_5998(eanHand);
        boolean hasFood = false;
        RangedWrapper backpackInv = maid.getAvailableBackpackInv();
        for (int i = 0; i < backpackInv.getSlots(); ++i) {
            class_1799 stack = backpackInv.getStackInSlot(i);
            if (stack.method_7960() || !this.isBreatheFood(maid, stack)) continue;
            class_1799 foodStack = backpackInv.extractItem(i, backpackInv.getStackInSlot(i).method_7947(), false);
            class_1799 handStack = itemInHand.method_7972();
            maid.method_6122(eanHand, foodStack);
            maid.memoryHandItemStack(handStack);
            itemInHand = maid.method_5998(eanHand);
            hasFood = true;
            break;
        }
        if (hasFood) {
            this.startEatBreatheItem(maid, itemInHand, eanHand);
        }
        return hasFood;
    }

    private void startEatBreatheItem(EntityMaid maid, class_1799 stack, class_1268 hand) {
        maid.getSwimManager().setEatBreatheItem(true);
        class_4174 foodProperties = (class_4174)stack.method_57824(class_9334.field_50075);
        float total = 0.0f;
        if (foodProperties != null) {
            int nutrition = foodProperties.comp_2491();
            float saturationModifier = foodProperties.comp_2492();
            total = (float)nutrition + (float)nutrition * saturationModifier * 2.0f;
        }
        maid.method_6019(hand);
        if ((float)maid.method_59922().method_43048(5) < total) {
            float healCount = Math.max(total / 5.0f, 1.0f);
            maid.method_6025(healCount);
            NetworkHandler.sendToNearby((class_1297)maid, new SpawnParticlePackage(maid.method_5628(), SpawnParticlePackage.Type.HEAL, stack.method_7935((class_1309)maid)));
        }
    }

    private boolean isBreatheFood(EntityMaid maid, class_1799 stack) {
        if (stack.method_7909() instanceof class_1812) {
            class_1844 mobEffects = (class_1844)stack.method_57824(class_9334.field_49651);
            if (mobEffects == null || !mobEffects.method_57405()) {
                return false;
            }
            for (class_1293 effect : mobEffects.method_57397()) {
                if (effect.method_5579() != class_1294.field_5923) continue;
                return true;
            }
            return false;
        }
        class_4174 foodProperties = (class_4174)stack.method_57824(class_9334.field_50075);
        if (foodProperties == null) {
            return false;
        }
        List effects = foodProperties.comp_2495();
        if (effects.isEmpty()) {
            return false;
        }
        for (class_4174.class_9423 effect : effects) {
            if (effect.comp_2496().method_5579() != class_1294.field_5923) continue;
            return true;
        }
        return false;
    }

    private void findAirPosition(class_3218 level, EntityMaid maid) {
        if (!maid.canBrainMoving()) {
            return;
        }
        class_8 nodeEvaluator = maid.method_5942().method_6342();
        MaidPathFindingBFS pathFinding = new MaidPathFindingBFS(nodeEvaluator, level, maid, 16.0f, 16);
        Optional<class_2338> match = pathFinding.find(blockPos -> this.givesAir(maid, (class_2338)blockPos));
        pathFinding.finish();
        if (match.isPresent() && maid.canPathReach(match.get())) {
            maid.getSwimManager().setGoingToBreath(true);
            class_4215.method_24561((class_1309)maid, (class_2338)match.get(), (float)0.5f, (int)1);
            return;
        }
        class_2338.class_2339 seaLevelPos = maid.method_24515().method_25503().method_33098(level.method_8615() + 1);
        if (this.givesAir(maid, (class_2338)seaLevelPos) && maid.canPathReach((class_2338)seaLevelPos)) {
            maid.getSwimManager().setGoingToBreath(true);
            class_4215.method_24561((class_1309)maid, (class_2338)seaLevelPos, (float)0.5f, (int)1);
            return;
        }
        int seaLevelOffset = 2;
        Iterable canBreathPos = class_2338.method_10094((int)(seaLevelPos.method_10263() - 2), (int)seaLevelPos.method_10264(), (int)(seaLevelPos.method_10260() - 2), (int)(seaLevelPos.method_10263() + 2), (int)seaLevelPos.method_10264(), (int)(seaLevelPos.method_10260() + 2));
        for (class_2338 canBreathPo : canBreathPos) {
            if (!this.givesAir(maid, canBreathPo) || !maid.canPathReach(canBreathPo)) continue;
            maid.getSwimManager().setGoingToBreath(true);
            class_4215.method_24561((class_1309)maid, (class_2338)canBreathPo, (float)0.5f, (int)1);
            return;
        }
    }

    private boolean givesAir(EntityMaid maid, class_2338 pos) {
        class_1937 level = maid.field_6002;
        class_2680 blockState = level.method_8320(pos);
        boolean noFluid = level.method_8316(pos).method_15769() || blockState.method_27852(class_2246.field_10422);
        return noFluid && blockState.method_26220((class_1922)level, pos).method_1110();
    }
}

