package cn.sh1rocu.touhoulittlemaid.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1676;
import net.minecraft.class_239;

public class ProjectileImpactEvent extends CancellableEvent {
    private final class_239 ray;
    private final class_1676 projectile;

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (final Callback callback : callbacks)
            callback.post(event);
    });

    public ProjectileImpactEvent(class_1676 projectile, class_239 ray) {
        this.ray = ray;
        this.projectile = projectile;
    }

    public class_239 getRayTraceResult() {
        return ray;
    }

    public class_1676 getProjectile() {
        return projectile;
    }

    public interface Callback {
        void post(ProjectileImpactEvent event);
    }
}