package com.github.tartaricacid.touhoulittlemaid.api.block;


import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3499;

public interface IMultiBlock {
    /**
     * 触发的构建多方块结构时，点击的方块是否为核心方块
     *
     * @param blockState 点击的方块
     * @return 是否为核心方块
     */
    boolean isCoreBlock(class_2680 blockState);

    /**
     * 触发的构建多方块结构时，朝向是否正确
     *
     * @param direction 朝向
     * @return 是否为合法的触发方向
     */
    boolean directionIsSuitable(class_2350 direction);

    /**
     * 获取多方块结构的中心点
     *
     * @param direction 朝向
     * @return 多方块结构的中心点
     */
    class_2338 getCenterPos(class_2350 direction);

    /**
     * 获取多方块结构模板
     *
     * @param world     世界
     * @param direction 朝向
     * @return 多方块结构模板
     */
    class_3499 getTemplate(class_3218 world, class_2350 direction);

    /**
     * 是否匹配该多方块结构
     *
     * @param world     世界实例
     * @param posStart  起始坐标
     * @param direction 判定匹配时的朝向，用来应用到一些具有方向的多方块结构
     * @param template  结构模板
     * @return 是否匹配
     */
    boolean isMatch(class_1937 world, class_2338 posStart, class_2350 direction, class_3499 template);

    /**
     * 修建多方块结构的逻辑
     *
     * @param worldIn   世界实例
     * @param posStart  起始坐标
     * @param direction 判定匹配时的朝向，用来应用到一些具有方向的多方块结构
     * @param template  结构模板
     */
    void build(class_1937 worldIn, class_2338 posStart, class_2350 direction, class_3499 template);
}
