package com.github.tartaricacid.touhoulittlemaid.block;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlock;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.api.block.IBoardGameBlock;
import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position;
import com.github.tartaricacid.touhoulittlemaid.block.properties.GomokuPart;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.message.WChessToClientPackage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityWChess;
import com.github.tartaricacid.touhoulittlemaid.util.WChessUtil;
import com.mojang.serialization.MapCodec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_702;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;

public class BlockWChess extends BlockJoy implements IBoardGameBlock, IBlock {
    public static final class_2754<GomokuPart> PART = class_2754.method_11850("part", GomokuPart.class);
    public static final class_265 AABB = class_2248.method_9541(0, 0, 0, 16, 2, 16);

    public BlockWChess() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9626(class_2498.field_11547).method_9629(2.0F, 3.0F).method_51369().method_22488());
        this.method_9590(this.field_10647.method_11664().method_11657(PART, GomokuPart.CENTER).method_11657(FACING, class_2350.field_11043));
    }

    private static void handleWChessRemove(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236) {
            GomokuPart part = state.method_11654(PART);
            class_2338 centerPos = pos.method_10059(new class_2382(part.getPosX(), 0, part.getPosY()));
            class_2586 te = world.method_8321(centerPos);
            method_9577(world, centerPos, InitItems.WCHESS.method_7854());
            if (te instanceof TileEntityWChess) {
                for (int i = -1; i < 2; i++) {
                    for (int j = -1; j < 2; j++) {
                        world.method_8501(centerPos.method_10069(i, 0, j), class_2246.field_10124.method_9564());
                    }
                }
            }
        }
    }


    public static void maidMove(class_3222 player, class_1937 level, class_2338 pos, int move, boolean maidLost, boolean playerLost) {
        if (level.method_8321(pos) instanceof TileEntityWChess chess) {
            if (chess.isPlayerTurn()) {
                return;
            }

            Position chessData = chess.getChessData();
            UUID sitId = chess.getSitId();
            // 女仆输，以防作弊，再检查一次
            if (maidLost && WChessUtil.isMaid(chessData) && chessData.isMate()) {
                chess.setCheckmate(true);
                chess.refresh();

                if (level instanceof class_3218 serverLevel && serverLevel.method_14190(sitId) instanceof EntitySit sit
                        && sit.method_31483() instanceof EntityMaid maid && maid.method_6171(player)) {
                    // TODO: 暂时不加段位系统
                    maid.getFavorabilityManager().apply(Type.WCHESS_WIN);
                    maid.getGameRecordManager().markStatue(false);
                    InitTrigger.MAID_EVENT.trigger(player, TriggerType.WIN_WCHESS);
                }

                return;
            }

            // 如果吃子/移兵了，那么重置计数器（该计数器用于判断限着和长将）
            if (chessData.makeMove(move)) {
                int pcSrc = chessData.squares[Position.SRC(move)];
                if (chessData.captured() || Position.PIECE_TYPE(pcSrc) == Position.PIECE_PAWN) {
                    chessData.setIrrev();
                }
            }
            chess.setSelectChessPoint(Position.DST(move));
            chess.setCheckmate(playerLost);

            // 如果玩家没输，那么检查其他和局情况
            if (!playerLost) {
                if (WChessUtil.reachMoveLimit(chessData)) {
                    // 判断是否 50 回合限制
                    chess.setMoveNumberLimit(true);
                } else if (WChessUtil.isRepeat(chessData)) {
                    // 判断是否长打
                    chess.setRepeat(true);
                }
            }

            if (level instanceof class_3218 serverLevel && serverLevel.method_14190(sitId) instanceof EntitySit sit && sit.method_31483() instanceof EntityMaid maid) {
                maid.method_6104(class_1268.field_5808);
                if (playerLost) {
                    maid.getGameRecordManager().markStatue(true);
                }
            }
            level.method_8396(null, pos, InitSounds.GOMOKU, class_3419.field_15245, 1.0f, 0.8F + level.field_9229.method_43057() * 0.4F);
            chess.refresh();
        }
    }

    @Override
    public void startMaidSit(EntityMaid maid, class_2680 state, class_1937 worldIn, class_2338 pos) {
        if (worldIn instanceof class_3218 serverLevel && worldIn.method_8321(pos) instanceof TileEntityJoy joy) {
            class_1297 oldSitEntity = serverLevel.method_14190(joy.getSitId());
            if (oldSitEntity != null && oldSitEntity.method_5805()) {
                return;
            }
            class_2350 face = state.method_11654(FACING).method_10153();
            class_243 position = new class_243(0.5 + face.method_10148() * 2, 0.1, 0.5 + face.method_10165() * 2);
            EntitySit newSitEntity = new EntitySit(worldIn, class_243.method_49273(pos, position.field_1352, position.field_1351, position.field_1350), this.getTypeName(), pos);
            newSitEntity.method_36456(face.method_10153().method_10144() + this.sitYRot());
            worldIn.method_8649(newSitEntity);
            joy.setSitId(newSitEntity.method_5667());
            joy.method_5431();
            maid.method_5804(newSitEntity);
        }
    }

    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        handleWChessRemove(world, pos, state);
        return super.method_9576(world, pos, state, player);
    }

    @Environment(EnvType.CLIENT)
    @Override
    public boolean addHitEffects(class_2680 state, class_1937 world, class_239 target, class_702 manager) {
        return false;
    }

    @Override
    public void onBlockExploded(class_2680 state, class_1937 world, class_2338 pos, class_1927 explosion) {
        handleWChessRemove(world, pos, state);
        IBlock.super.onBlockExploded(state, world, pos, explosion);
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2338 centerPos = context.method_8037();
        for (int i = -1; i < 2; i++) {
            for (int j = -1; j < 2; j++) {
                class_2338 searchPos = centerPos.method_10069(i, 0, j);
                if (!context.method_8045().method_8320(searchPos).method_26166(context)) {
                    return null;
                }
            }
        }
        return this.method_9564().method_11657(FACING, context.method_8042().method_10153());
    }

    @Override
    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, @javax.annotation.Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(worldIn, pos, state, placer, stack);
        if (worldIn.field_9236) {
            return;
        }
        for (int i = -1; i < 2; i++) {
            for (int j = -1; j < 2; j++) {
                class_2338 searchPos = pos.method_10069(i, 0, j);
                GomokuPart part = GomokuPart.getPartByPos(i, j);
                if (part != null && !part.isCenter()) {
                    worldIn.method_8652(searchPos, state.method_11657(PART, part), class_2248.field_31036);
                }
            }
        }
    }

    @Override
    public class_9062 method_55765(class_1799 itemStack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (level instanceof class_3218 serverLevel && hand == class_1268.field_5808 && player.method_6047().method_7960()) {
            GomokuPart part = state.method_11654(PART);
            class_2338 centerPos = pos.method_10059(new class_2382(part.getPosX(), 0, part.getPosY()));
            class_2586 te = level.method_8321(centerPos);

            if (!(te instanceof TileEntityWChess chess)) {
                return class_9062.field_47733;
            }
            if (!chess.isPlayerTurn() && !chess.isCheckmate()) {
                return class_9062.field_47733;
            }

            // 检查女仆
            class_1297 sitEntity = serverLevel.method_14190(chess.getSitId());
            if (sitEntity == null || !sitEntity.method_5805() || !(sitEntity.method_31483() instanceof EntityMaid maid)) {
                player.method_43496(class_2561.method_43471("message.touhou_little_maid.gomoku.no_maid"));
                return class_9062.field_47733;
            }
            // 检查是不是自己的女仆
            if (MaidConfig.MAID_GOMOKU_OWNER_LIMIT.get() && !maid.method_6171(player)) {
                player.method_43496(class_2561.method_43471("message.touhou_little_maid.gomoku.not_owner"));
                return class_9062.field_47733;
            }

            // 点击坐标的转换
            class_2350 facing = state.method_11654(FACING);
            class_243 clickPos = hit.method_17784()
                    .method_1023(pos.method_10263(), pos.method_10264(), pos.method_10260())
                    .method_1031(part.getPosX() - 0.5, 0, part.getPosY() - 0.5)
                    .method_1024(facing.method_10144() * class_3532.field_29847);

            // 重置棋盘
            boolean clickResetArea = WChessUtil.isClickResetArea(clickPos);
            if (clickResetArea) {
                chess.reset();
                chess.refresh();
                level.method_8396(null, centerPos, InitSounds.GOMOKU_RESET, class_3419.field_15245, 1.0f, 1.0f);
                maid.getGameRecordManager().resetStatue();
            }

            // 没有点击到棋盘上，返回
            int nowClick = WChessUtil.getClickPosition(clickPos);
            if (nowClick < 0 || !Position.IN_BOARD(nowClick)) {
                return class_9062.field_47732;
            }

            // 玩家已经输了，不能下棋
            if (chess.isCheckmate() && chess.isPlayerTurn()) {
                return class_9062.field_47733;
            }

            // 50 回合自然限着、长将不能下棋
            if (chess.isMoveNumberLimit() || chess.isRepeat()) {
                return class_9062.field_47733;
            }

            // 处理点击棋子的逻辑
            Position chessData = chess.getChessData();
            byte[] squares = chessData.squares;
            int preClick = chess.getSelectChessPoint();
            if (preClick < 0 || squares.length <= preClick) {
                preClick = 0;
            }
            byte prePiece = squares[preClick];
            byte nowPiece = squares[nowClick];

            // 如果前一个选择为空，或者选中的是黑方，说明没有选中棋子
            if (prePiece <= 0 || WChessUtil.isBlack(prePiece)) {
                // 当前点击的是白方棋子
                if (WChessUtil.isWhite(nowPiece)) {
                    chess.setSelectChessPoint(nowClick);
                    chess.refresh();
                    level.method_8396(null, pos, InitSounds.GOMOKU, class_3419.field_15245, 1.0f, 0.8F + level.field_9229.method_43057() * 0.4F);
                }
                return class_9062.field_47728;
            }

            // 如果选的都是白方棋子，重选
            if (WChessUtil.isWhite(prePiece) && WChessUtil.isWhite(nowPiece)) {
                chess.setSelectChessPoint(nowClick);
                chess.refresh();
                level.method_8396(null, pos, InitSounds.GOMOKU, class_3419.field_15245, 1.0f, 0.8F + level.field_9229.method_43057() * 0.4F);
                return class_9062.field_47728;
            }

            // 判断移动是否合法
            int move = Position.MOVE(preClick, nowClick);
            if (!chessData.legalMove(move)) {
                return class_9062.field_47733;
            }

            // 没有将军，正常移动
            boolean notChecked = chessData.makeMove(move);
            if (notChecked) {
                int pcSrc = chessData.squares[Position.SRC(move)];
                // 如果吃子、动兵了，那么重置计数器（该计数器用于判断自然限着和长将）
                if (chessData.captured() || Position.PIECE_TYPE(pcSrc) == Position.PIECE_PAWN) {
                    chessData.setIrrev();
                }
                chess.addChessCounter();
                chess.setSelectChessPoint(nowClick);
                chess.refresh();
                level.method_8396(null, pos, InitSounds.GOMOKU, class_3419.field_15245, 1.0f, 0.8F + level.field_9229.method_43057() * 0.4F);
                if (player instanceof class_3222 serverPlayer) {
                    ServerPlayNetworking.send(serverPlayer, new WChessToClientPackage(centerPos, chessData.toFen()));
                }
                return class_9062.field_47728;
            }

            // 如果将军，那么给予提示
            player.method_43496(class_2561.method_43471("message.touhou_little_maid.cchess.check"));
            level.method_8396(null, pos, class_3417.field_14793.comp_349(), class_3419.field_15245, 1.0f, 0.8F + level.field_9229.method_43057() * 0.4F);
            return class_9062.field_47733;
        }
        return class_9062.field_47732;
    }

    @Override
    protected class_243 sitPosition() {
        return class_243.field_1353;
    }

    @Override
    protected String getTypeName() {
        return Type.GOMOKU.getTypeName();
    }

    @Override
    protected int sitYRot() {
        return 0;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(PART, FACING);
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (state.method_11654(PART).isCenter()) {
            return new TileEntityWChess(pos, state);
        }
        return null;
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return method_54094((properties) -> new BlockWChess());
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return AABB;
    }
}
