package com.github.tartaricacid.touhoulittlemaid.tileentity;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlockEntityPersistentData;
import com.github.tartaricacid.touhoulittlemaid.api.block.IBoardGameEntityBlock;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

public class TileEntityGomoku extends TileEntityJoy implements IBoardGameEntityBlock, IBlockEntityPersistentData {
    public static final class_2591<TileEntityGomoku> TYPE = class_2591.class_2592.method_20528(TileEntityGomoku::new, InitBlocks.GOMOKU).method_11034(null);
    private static final String CHESS_DATA = "ChessData";
    private static final String IN_PROGRESS = "InProgress";
    private static final String PLAYER_TURN = "PlayerTurn";
    private static final String CHESS_COUNTER = "ChessCounter";
    private static final String LATEST_CHESS_POINT = "LatestChessPoint";
    private byte[][] chessData = new byte[15][15];
    private boolean inProgress = true;
    private boolean playerTurn = true;
    private int chessCounter = 0;
    private Point latestChessPoint = Point.NULL;

    public TileEntityGomoku(class_2338 pos, class_2680 blockState) {
        super(TYPE, pos, blockState);
    }

    @Override
    protected void method_11007(class_2487 pTag, class_7225.class_7874 pRegistries) {
        class_2499 listTag = new class_2499();
        for (byte[] chessRow : chessData) {
            listTag.add(new class_2479(chessRow));
        }
        getPersistentData().method_10566(CHESS_DATA, listTag);
        getPersistentData().method_10556(IN_PROGRESS, this.inProgress);
        getPersistentData().method_10556(PLAYER_TURN, this.playerTurn);
        getPersistentData().method_10569(CHESS_COUNTER, this.chessCounter);
        getPersistentData().method_10566(LATEST_CHESS_POINT, Point.toTag(this.latestChessPoint));
        super.method_11007(pTag, pRegistries);
    }

    @Override
    public void method_11014(class_2487 pTag, class_7225.class_7874 pRegistries) {
        super.method_11014(pTag, pRegistries);
        class_2499 listTag = getPersistentData().method_10554(CHESS_DATA, class_2520.field_33257);
        for (int i = 0; i < listTag.size(); i++) {
            class_2479 byteArray = (class_2479) listTag.method_10534(i);
            this.chessData[i] = byteArray.method_10521();
        }
        this.inProgress = getPersistentData().method_10577(IN_PROGRESS);
        this.playerTurn = getPersistentData().method_10577(PLAYER_TURN);
        this.chessCounter = getPersistentData().method_10550(CHESS_COUNTER);
        this.latestChessPoint = Point.fromTag(getPersistentData().method_10562(LATEST_CHESS_POINT));
    }

    public void reset() {
        this.chessData = new byte[15][15];
        this.inProgress = true;
        this.playerTurn = true;
        this.chessCounter = 0;
        this.latestChessPoint = Point.NULL;
    }

    public byte[][] getChessData() {
        return chessData;
    }

    public void setChessData(List<byte[]> arrayList) {
        for (int i = 0; i < arrayList.size(); i++) {
            this.chessData[i] = arrayList.get(i);
        }
    }

    public void setChessData(int x, int y, int type) {
        this.chessData[x][y] = (byte) type;
        this.latestChessPoint = new Point(x, y, type);
        this.chessCounter += 1;
    }

    public boolean isPlayerTurn() {
        return playerTurn;
    }

    public void setPlayerTurn(boolean playerTurn) {
        this.playerTurn = playerTurn;
    }

    public boolean isInProgress() {
        return inProgress;
    }

    public void setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
    }

    public int getChessCounter() {
        return chessCounter;
    }

    public Point getLatestChessPoint() {
        return latestChessPoint;
    }
}
