/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.molang.parser.ast;

import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.Expression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.ExpressionVisitor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class BinaryExpression
implements Expression {
    private final Op op;
    private final Expression left;
    private final Expression right;

    public BinaryExpression(@NotNull Op op, @NotNull Expression left, @NotNull Expression right) {
        this.op = Objects.requireNonNull(op, "op");
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
    }

    @NotNull
    public Op op() {
        return this.op;
    }

    @NotNull
    public Expression left() {
        return this.left;
    }

    @NotNull
    public Expression right() {
        return this.right;
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitBinary(this);
    }

    public String toString() {
        return this.op.name() + "(" + String.valueOf(this.left) + ", " + String.valueOf(this.right) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryExpression that = (BinaryExpression)o;
        if (this.op != that.op) {
            return false;
        }
        if (!this.left.equals(that.left)) {
            return false;
        }
        return this.right.equals(that.right);
    }

    public int hashCode() {
        int result = this.op.hashCode();
        result = 31 * result + this.left.hashCode();
        result = 31 * result + this.right.hashCode();
        return result;
    }

    public static enum Op {
        AND(1800, 0),
        OR(1600, 1),
        LT(2200, 2),
        LTE(2200, 3),
        GT(2200, 4),
        GTE(2200, 5),
        ADD(2400, 6),
        SUB(2400, 7),
        MUL(2600, 8),
        DIV(2600, 9),
        ARROW(3000, 10),
        NULL_COALESCE(1200, 11),
        ASSIGN(1, 12),
        CONDITIONAL(1400, 13),
        EQ(2000, 14),
        NEQ(2000, 15);

        private final int precedence;
        private final int index;

        private Op(int precedence, int index) {
            this.precedence = precedence;
            this.index = index;
        }

        public int precedence() {
            return this.precedence;
        }

        public int index() {
            return this.index;
        }
    }
}

