package com.github.tartaricacid.touhoulittlemaid.api.entity;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.api.event.ConvertMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.util.BiomeCacheUtil;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

/**
 * 女仆部分方法的接口化
 * <p>
 * 目前仅用于渲染
 */
public interface IMaid {
    /**
     * 转换为接口，同时发送转换事件
     *
     * @param mob 需要转换的实体对象
     * @return 转换的 Maid 对象
     */
    @Nullable
    static IMaid convert(class_1308 mob) {
        // 如果是继承了这个接口的，可以直接转换
        if (mob instanceof IMaid maid) {
            return maid;
        }
        // 如果不是，那么发送事件进行检查
        // 这样就可以兼容其他模组
        var event = new ConvertMaidEvent(mob);
        ConvertMaidEvent.CALLBACK.invoker().post(event);
        return event.getMaid();
    }

    /**
     * 将 Mob 转换成 Maid 对象，转换不成功返回 Null
     */
    @Nullable
    static EntityMaid convertToMaid(class_1308 mob) {
        IMaid convert = convert(mob);
        if (convert == null) {
            return null;
        }
        return convert.asStrictMaid();
    }

    /**
     * 转换成女仆对象
     *
     * @return 为 null 表示转换不了
     */
    @Nullable
    default EntityMaid asStrictMaid() {
        return null;
    }

    /**
     * 获取模型 ID
     */
    String getModelId();

    /**
     * 女仆可以调用 YSM 渲染
     *
     * @return 是否当前使用的是 YSM 渲染模型
     */
    default boolean isYsmModel() {
        return false;
    }

    /**
     * 设置是否使用 YSM 渲染模型
     */
    default void setIsYsmModel(boolean isYsmModel) {
    }

    /**
     * 获取 YSM 模型 ID
     *
     * @return 模型 ID 可能是任意字符
     */
    default String getYsmModelId() {
        return StringUtils.EMPTY;
    }

    /**
     * 获取 YSM 模型材质名称
     *
     * @return 材质名称可能是任意字符
     */
    default String getYsmModelTexture() {
        return StringUtils.EMPTY;
    }

    /**
     * 获取 YSM 模型显示名称
     *
     * @return 显示名称
     */
    default class_2561 getYsmModelName() {
        return class_2561.method_43473();
    }

    /**
     * 设置 YSM 模型 ID 和材质名称。还有显示名称
     */
    default void setYsmModel(String modelId, String texture, class_2561 name) {
    }

    /**
     * 播放轮盘动画
     */
    default void playRouletteAnim(String rouletteAnim) {
    }

    /**
     * 停止轮盘动画
     */
    default void stopRouletteAnim() {
    }

    /**
     * 转成原实体对象
     */
    class_1308 asEntity();

    // 下方为女仆物品使用接口

    /**
     * 物品使用缓存，应当创建 ItemStack[] 来缓存数据。
     * 如果实体会使用物品，理应Override这个方法，在实体中缓存。
     */
    default class_1799[] getHandItemsForAnimation() {
        return new class_1799[]{class_1799.field_8037, class_1799.field_8037};
    }

    /**
     * 女仆任务：
     * 如果实体会进行类似女仆任务的行为，则可以在这里模拟，以供动画使用。
     * 例如攻击，远程攻击等等
     */
    default IMaidTask getTask() {
        return TaskManager.getIdleTask();
    }

    /**
     * 女仆手臂是否举起：在攻击动画中使用
     */
    default boolean isSwingingArms() {
        return false;
    }

    // 下方为女仆属性接口

    default int getExperience() {
        return 0;
    }

    default boolean isMaidInSittingPose() {
        return false;
    }

    default boolean isBegging() {
        return false;
    }

    default int getFavorability() {
        return 0;
    }

    /**
     * 获取背部显示物品
     */
    default class_1799 getBackpackShowItem() {
        return class_1799.field_8037;
    }

    /**
     * 背包类型
     */
    default IMaidBackpack getMaidBackpackType() {
        return BackpackManager.getEmptyBackpack();
    }

    default boolean hasBackpack() {
        return getMaidBackpackType() != BackpackManager.getEmptyBackpack();
    }

    // 下方为 MC 实体属性，无需 Override

    default boolean hasHelmet() {
        return !asEntity().method_6118(class_1304.field_6169).method_7960();
    }

    default boolean hasChestPlate() {
        return !asEntity().method_6118(class_1304.field_6174).method_7960();
    }

    default boolean hasLeggings() {
        return !asEntity().method_6118(class_1304.field_6172).method_7960();
    }

    default boolean hasBoots() {
        return !asEntity().method_6118(class_1304.field_6166).method_7960();
    }

    default boolean onHurt() {
        return asEntity().field_6235 > 0;
    }

    default boolean hasFishingHook() {
        return false;
    }

    default boolean onClimbable() {
        return false;
    }

    // 下方为 Deprecated 方法，仅用于适配旧版本模型，无需 Override

    @Deprecated
    default String getAtBiomeTemp() {
        float temp = BiomeCacheUtil.getCacheBiome(asEntity()).method_8712();
        if (temp < 0.15) {
            return "COLD";
        } else if (temp < 0.55) {
            return "OCEAN";
        } else if (temp < 0.95) {
            return "MEDIUM";
        } else {
            return "WARM";
        }
    }

    @Deprecated
    default boolean hasSasimono() {
        return false;
    }

    @Deprecated
    default boolean isSitInJoyBlock() {
        return false;
    }

    @Deprecated
    default int getDim() {
        class_5321<class_1937> dim = asEntity().field_6002.method_27983();
        if (dim.equals(class_1937.field_25179)) {
            return 0;
        }
        if (dim.equals(class_1937.field_25180)) {
            return -1;
        }
        if (dim.equals(class_1937.field_25181)) {
            return 1;
        }
        return 0;
    }
}
