package com.github.tartaricacid.touhoulittlemaid.block;

import cn.sh1rocu.touhoulittlemaid.api.extension.IRedstoneConnect;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.ItemModelSwitcher;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenSwitcherGuiPackage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import com.mojang.serialization.MapCodec;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_9062;
import net.minecraft.world.level.block.*;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nullable;
import java.util.UUID;

public class BlockModelSwitcher extends class_2237 implements IRedstoneConnect {
    public static final class_2753 FACING = class_2741.field_12481;

    public BlockModelSwitcher() {
        super(class_4970.class_2251.method_9637().method_9626(class_2498.field_11544).method_9629(50.0F, 1200.0F));
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
    }

    @Override
    public boolean tlm$canConnectRedstone(class_2680 state, class_1922 level, class_2338 pos, @Nullable class_2350 direction) {
        class_2350 value = state.method_11654(FACING);
        if (direction != null) {
            return direction == value.method_10170() || direction == value.method_10160();
        }
        return false;
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return new TileEntityModelSwitcher(pPos, pState);
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        return this.method_9564().method_11657(FACING, pContext.method_8042().method_10153());
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        pBuilder.method_11667(FACING);
    }

    @Override
    public void method_9612(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2248 pBlock, class_2338 pFromPos, boolean pIsMoving) {
        if (pLevel.field_9236) {
            return;
        }
        class_2350 direction = pState.method_11654(FACING);
        boolean leftSignal = pLevel.method_49808(pPos.method_10081(direction.method_10160().method_10163()), direction.method_10160()) > 0;
        boolean rightSignal = pLevel.method_49808(pPos.method_10081(direction.method_10170().method_10163()), direction.method_10170()) > 0;
        boolean hasSignal = leftSignal || rightSignal;
        class_2586 blockEntity = pLevel.method_8321(pPos);
        if (blockEntity instanceof TileEntityModelSwitcher switcher && pLevel instanceof class_3218) {
            if (switcher.isPowered() != hasSignal) {
                switcher.setPowered(!switcher.isPowered());
                if (!switcher.isPowered()) {
                    return;
                }
                UUID uuid = switcher.getUuid();
                if (uuid == null) {
                    return;
                }
                int index = calculateIndex(leftSignal, switcher.getInfoList().size(), switcher.getIndex());
                switcher.setIndex(index);
                class_3218 serverLevel = (class_3218) pLevel;
                class_1297 entity = serverLevel.method_14190(uuid);
                if (entity instanceof EntityMaid && entity.method_5805()) {
                    this.setMaidData(switcher, (EntityMaid) entity);
                }
            }
        }
    }

    private void setMaidData(TileEntityModelSwitcher switcher, EntityMaid maid) {
        TileEntityModelSwitcher.ModeInfo modelInfo = switcher.getModelInfo();
        if (modelInfo != null) {
            maid.setModelId(modelInfo.getModelId().toString());
            if (StringUtils.isNotBlank(modelInfo.getText())) {
                maid.method_5665(class_2561.method_43470(modelInfo.getText()));
                maid.method_5880(true);
            } else {
                maid.method_5665(null);
                maid.method_5880(false);
            }
            class_2338 blockPos = maid.method_24515();
            maid.method_5814(blockPos.method_10263() + 0.5, blockPos.method_10264(), blockPos.method_10260() + 0.5);
            maid.method_36456(modelInfo.getDirection().method_10144());
            maid.method_5847(modelInfo.getDirection().method_10144());
            maid.method_5636(modelInfo.getDirection().method_10144());
        }
    }

    private int calculateIndex(boolean leftSignal, int size, int index) {
        if (leftSignal) {
            if (index < size - 1) {
                index++;
            } else {
                index = 0;
            }
        } else {
            if (index > 0) {
                index--;
            } else {
                index = size - 1;
            }
        }
        return index;
    }

    @Override
    public class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        if (worldIn.method_8321(pos) instanceof TileEntityModelSwitcher) {
            if (!worldIn.field_9236 && player instanceof class_3222 serverPlayer) {
                ServerPlayNetworking.send(serverPlayer, new OpenSwitcherGuiPackage(pos));
            }
            return class_9062.method_55644(worldIn.field_9236);
        }
        return super.method_55765(stack, state, worldIn, pos, player, handIn, hit);
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, @Nullable class_1309 pPlacer, class_1799 pStack) {
        class_2586 te = pLevel.method_8321(pPos);
        if (te instanceof TileEntityModelSwitcher tileEntityModelSwitcher) {
            ItemModelSwitcher.itemStackToTileEntity(pLevel.method_30349(), pStack, tileEntityModelSwitcher);
            tileEntityModelSwitcher.refresh();
        }
    }

    @Override
    public void method_9536(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 newState, boolean isMoving) {
        class_2586 te = worldIn.method_8321(pos);
        if (te instanceof TileEntityModelSwitcher) {
            method_9577(worldIn, pos, ItemModelSwitcher.tileEntityToItemStack(worldIn.method_30349(), (TileEntityModelSwitcher) te));
        }
        super.method_9536(state, worldIn, pos, newState, isMoving);
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return method_54094((properties) -> new BlockModelSwitcher());
    }

    @Override
    public class_2464 method_9604(class_2680 pState) {
        return class_2464.field_11458;
    }

    @Override
    public class_2680 method_9598(class_2680 pState, class_2470 pRot) {
        return pState.method_11657(FACING, pRot.method_10503(pState.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        return pState.method_26186(pMirror.method_10345(pState.method_11654(FACING)));
    }
}
