package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.GunCommonUtil;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.isValidResourceLocation;

public class ConditionTAC {
    private static final String EMPTY = "";
    private final List<String> nameTest = Lists.newArrayList();
    private final List<class_2960> idTest = Lists.newArrayList();

    public void addTest(String name) {
        if (!name.startsWith("tac:") || !name.contains("$")) {
            return;
        }
        String[] split = StringUtils.split(name, "$", 2);
        if (split.length < 2) {
            return;
        }
        String itemId = split[1];
        if (isValidResourceLocation(itemId)) {
            nameTest.add(name);
            idTest.add(class_2960.method_60654(itemId));
        }
    }

    public String doTest(class_1799 itemInHand, String prefix) {
        if (itemInHand.method_7960()) {
            return EMPTY;
        }
        class_2960 gunId = GunCommonUtil.getGunId(itemInHand);
        if (gunId == null) {
            return EMPTY;
        }
        if (idTest.contains(gunId)) {
            String animationName = prefix.substring(0, prefix.length() - 1) + "$" + gunId;
            if (nameTest.contains(animationName)) {
                return animationName;
            }
        }
        return EMPTY;
    }
}
