package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1308;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.isValidResourceLocation;

public class ConditionalChair {
    private static final String EMPTY = "";
    private final List<String> idTest = Lists.newArrayList();
    private final String idPre;

    public ConditionalChair() {
        this.idPre = "chair$";
    }

    public void addTest(String name) {
        int preSize = this.idPre.length();
        if (name.length() <= preSize) {
            return;
        }
        String substring = name.substring(preSize);
        if (name.startsWith(idPre) && isValidResourceLocation(substring)) {
            idTest.add(substring);
        }
    }

    public String doTest(class_1308 maid) {
        class_1297 vehicle = maid.method_5854();
        if (!(vehicle instanceof EntityChair chair)) {
            return EMPTY;
        }
        return doIdTest(chair);
    }

    private String doIdTest(EntityChair chair) {
        if (idTest.isEmpty()) {
            return EMPTY;
        }
        String modelId = chair.getModelId();
        if (idTest.contains(modelId)) {
            return idPre + modelId;
        }
        return EMPTY;
    }
}
