package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model;

import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ScreenAccessor;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ImageButtonWithId;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TouhouImageButton;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.apache.commons.lang3.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

import static com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo.ENCRYPT_EGG_NAME;
import static com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo.NORMAL_EGG_NAME;

public abstract class AbstractModelGui<T extends class_1309, E extends IModelInfo> extends class_437 {
    public static final class_4185.class_4241 NO_PRESS = (b) -> {
    };

    private static final class_2960 BG = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/skin_select.png");
    private static final class_2960 SIDE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/skin_select_side.png");
    private static final class_2960 EMPTY_ICON = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/empty_model_pack_icon.png");

    private static final class_1049 EMPTY_ICON_TEXTURE = new class_1049(EMPTY_ICON);

    protected final T entity;
    private final SkinGuiNumber<E> guiNumber;
    private final List<CustomModelPack<E>> modelPackList;

    private class_342 searchBox;
    private String searchText = "";
    private List<E> filteredModelList = null;
    /**
     * 是否处于搜索模式
     */
    private boolean isSearchMode = false;
    /**
     * 所有 pack 中的模型列表
     */
    private List<E> allModelsList = null;

    public AbstractModelGui(T entity, List<CustomModelPack<E>> listPack) {
        super(class_2561.method_43470("Custom Model GUI"));
        this.entity = entity;
        this.modelPackList = listPack;
        this.guiNumber = new SkinGuiNumber<>(modelPackList);

        setPageIndex(class_3532.method_15340(getPageIndex(), 0, guiNumber.getPageSize() - 1));
        setPackIndex(class_3532.method_15340(getPackIndex(), 0, guiNumber.getPackSize() - 1));
        setRowIndex(class_3532.method_15340(getRowIndex(), 0, guiNumber.getRowSize(getPackIndex())));

        // 初始化所有模型列表（仅初始化一次）
        this.allModelsList = Lists.newArrayList();
        for (CustomModelPack<E> pack : modelPackList) {
            allModelsList.addAll(pack.getModelList());
        }
    }

    /**
     * 绘制左侧示例实体
     *
     * @param middleX 屏幕参考中点
     * @param middleY 屏幕参考中点
     * @param mouseX  鼠标 x 坐标
     * @param mouseY  鼠标 Y 坐标
     */
    protected abstract void drawLeftEntity(class_332 graphics, int middleX, int middleY, float mouseX, float mouseY);

    /**
     * 绘制右侧示例实体
     *
     * @param posX      实体所在的 x 坐标
     * @param posY      实体所在的 y 坐标
     * @param modelItem 该实体应该对应的模型数据
     */
    protected abstract void drawRightEntity(class_332 graphics, int posX, int posY, E modelItem);

    /**
     * 打开详情界面
     *
     * @param entity    实体
     * @param modelInfo 该实体应该对应的模型数据
     */
    protected abstract void openDetailsGui(T entity, E modelInfo);

    /**
     * 发包通知模型更改
     *
     * @param entity    实体
     * @param modelInfo 该实体应该对应的模型数据
     */
    protected abstract void notifyModelChange(T entity, E modelInfo);

    protected abstract void addModelCustomTips(E modelItem, List<class_2561> tooltips);

    protected abstract int getPackIndex();

    protected abstract void setPackIndex(int packIndex);

    protected abstract int getRowIndex();

    protected abstract void setRowIndex(int rowIndex);

    protected abstract int getPageIndex();

    protected abstract void setPageIndex(int packIndex);

    @Override
    public void method_25426() {
        // 清除按钮列表、标签列表，用来给后面重载按键用的
        this.method_37067();

        // 初始化时更新过滤列表
        this.updateFilteredModelList();

        int startX = this.field_22789 / 2 + 50;
        int startY = this.field_22790 / 2;

        // 模型包的分栏按钮
        for (int index = 0; index < 7; index++) {
            addTabButton(startX, startY, index);
        }

        // 关闭当前界面的按键
        this.method_37063(new TouhouImageButton(startX + 122, startY - 97, 21, 17,
                58, 201, 18, BG, b -> this.onClickCloseButton()));

        // 添加切换页面的按钮
        addPageButton(startX, startY);

        // 添加切换模型的按钮
        addModelButton(startX, startY);

        // 模型包翻页
        addScrollButton(startX, startY);

        // 添加开启、关闭模型包图标缓存的按钮
        class_5250 enableCache = class_2561.method_43471("gui.touhou_little_maid.skin.enable_cache");
        int checkBoxWidth = field_22793.method_27525(enableCache) + 20;
        int xOffset = (startX - 256 / 2) / 2 - checkBoxWidth / 2;
        class_4286 cacheCheckBox = class_4286.method_54787(enableCache, field_22793)
                .method_54789(xOffset, startY - 101)
                .method_54794(MiscConfig.MODEL_ICON_CACHE.get())
                .method_54791((checkBox, value) -> MiscConfig.MODEL_ICON_CACHE.set(value))
                .method_54788();
        this.method_37063(cacheCheckBox);

        // 创建搜索框（始终创建，根据模式控制可见性）
        int searchBoxWidth = 216;
        int searchBoxX = startX - 96;
        int searchBoxY = startY + 101;

        this.searchBox = new class_342(this.field_22793, searchBoxX, searchBoxY, searchBoxWidth, 18,
                class_2561.method_43471("gui.touhou_little_maid.skin.search"));
        this.searchBox.method_1880(48);
        this.searchBox.method_1858(true);
        this.searchBox.method_1868(0xFFFFFFFF);
        this.searchBox.method_1852(searchText);
        this.searchBox.method_47404(class_2561.method_43471("gui.touhou_little_maid.skin.search.hint")
                .method_27692(class_124.field_1063));
        this.searchBox.method_1863(this::onSearchTextChanged);

        // 根据搜索模式设置可见性
        this.searchBox.method_1862(isSearchMode);
        this.method_37063(this.searchBox);

        // 添加搜索标签（独立的标签，位于左下角）
        this.addSearchTabButton(startX, startY);
    }

    private void addModelButton(int startX, int startY) {
        // 使用过滤后的列表
        List<E> displayList = getDisplayModelList();

        // 起始坐标
        int offsetX = -100;
        int offsetY = -35;

        // 切割列表，让其一页最多显示 55 个模型（11列 x 5行），但是又不至于溢出
        int fromIndex = guiNumber.modelFromIndex(getRowIndex());
        // 确保 fromIndex 不超出列表范围
        if (fromIndex >= displayList.size()) {
            return;
        }

        int toIndex = Math.min(
                fromIndex + 55,  // 每页最多显示 55 个模型（11列 x 5行）
                displayList.size()  // 确保不超出过滤列表的大小
        );

        // 开始添加按键，顺便装填按键对应模型的索引
        for (E modelItem : displayList.subList(fromIndex, toIndex)) {
            this.method_37063(new TouhouImageButton(startX + offsetX - 8, startY + offsetY - 26, 15,
                    24, 41, 201, 24, BG, onModelButtonClick(modelItem)));

            // 往右绘制
            offsetX = offsetX + 20;

            // 如果超出一定限制，换行
            if (offsetX > 105) {
                offsetX = -100;
                offsetY = offsetY + 30;
            }
        }
    }

    private void addScrollButton(int startX, int startY) {
        TouhouImageButton upButton = new TouhouImageButton(startX - 256 / 2 + 253, startY - 73, 14,
                10, 24, 15, 10, SIDE, b -> {
            int row = class_3532.method_15340(getRowIndex() - 1, 0, getDisplayRowSize());
            if (row != getRowIndex()) {
                setRowIndex(row);
                this.method_25426();
            }
        });
        class_4185 downButton = new TouhouImageButton(startX - 256 / 2 + 253, startY - 73 + 156, 14,
                10, 38, 15, 10, SIDE, b -> {
            int row = class_3532.method_15340(getRowIndex() + 1, 0, getDisplayRowSize());
            if (row != getRowIndex()) {
                setRowIndex(row);
                this.method_25426();
            }
        });
        this.method_37063(upButton);
        this.method_37063(downButton);
    }

    private class_4185.class_4241 onModelButtonClick(E modelItem) {
        return (button) -> {
            if (method_25442()) {
                openDetailsGui(entity, modelItem);
            } else {
                notifyModelChange(entity, modelItem);
            }
        };
    }

    private void addPageButton(int startX, int startY) {
        class_4185 prePage = class_4185.method_46430(class_2561.method_43470("<"), b -> {
            setRowIndex(0);
            setPageIndex(class_3532.method_15340(getPageIndex() - 1, 0, guiNumber.getPageSize() - 1));
            setPackIndex(guiNumber.tabToPackIndex(0, getPageIndex()));
            this.method_25426();
        }).method_46433(startX - 119, startY - 101).method_46437(20, 20).method_46431();
        class_4185 nextPage = class_4185.method_46430(class_2561.method_43470(">"), b -> {
            setRowIndex(0);
            setPageIndex(class_3532.method_15340(getPageIndex() + 1, 0, guiNumber.getPageSize() - 1));
            setPackIndex(guiNumber.tabToPackIndex(0, getPageIndex()));
            this.method_25426();
        }).method_46433(startX + 99, startY - 101).method_46437(20, 20).method_46431();
        if (getPageIndex() == 0) {
            prePage.field_22763 = false;
        }
        if (getPageIndex() == guiNumber.getPageSize() - 1) {
            nextPage.field_22763 = false;
        }
        this.method_37063(prePage);
        this.method_37063(nextPage);
    }

    private void addTabButton(int startX, int startY, int index) {
        // 当前选中标签
        if (index == guiNumber.getTabIndex(getPackIndex()) && !isSearchMode) {
            // 当前选中的标签（选中状态）
            this.method_37063(new TouhouImageButton(startX - 98 + 28 * index, startY - 108,
                    28, 31, 116, 224, 0, BG, NO_PRESS));
            return;
        }

        // 其他标签
        if (index < guiNumber.getTabSize(getPackIndex())) {
            this.method_37063(new ImageButtonWithId(index, startX - 98 + 28 * index, startY - 105,
                    28, 25, 116, 194, 0, BG, b -> {
                ImageButtonWithId imageButton = (ImageButtonWithId) b;
                int packIndex = guiNumber.tabToPackIndex(imageButton.getIndex(), getPageIndex());
                setRowIndex(0);
                setPackIndex(packIndex);

                // 当点击其他标签页时，清空搜索状态
                isSearchMode = false;
                searchText = "";
                this.method_25426();
            }));
        }
    }

    /**
     * 添加搜索标签按钮（独立的标签，位于左下角）
     */
    private void addSearchTabButton(int startX, int startY) {
        // 搜索标签位置：右侧UI的左下角
        int searchTabX = startX - 121;
        int searchTabY = startY + 100;

        if (isSearchMode) {
            this.method_37063(new TouhouImageButton(searchTabX, searchTabY - 4, 24, 26,
                    145, 194, 0, BG, NO_PRESS));
        } else {
            this.method_37063(new TouhouImageButton(searchTabX, searchTabY, 24, 21,
                    145, 220, 0, BG, b -> {
                // 切换到搜索模式
                setRowIndex(0);
                isSearchMode = true;
                this.method_25426();
            }));
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_57734(partialTicks);

        graphics.method_51448().method_46416(0, 0, -100);

        // 中心点
        int middleX = this.field_22789 / 2 + 50;
        int middleY = this.field_22790 / 2;

        // 绘制灰色默认背景
        method_25420(graphics, mouseX, mouseY, partialTicks);

        // 绘制 GUI 背景
        graphics.method_25302(BG, middleX - 256 / 2, middleY - 80, 0, 0, 256, 180);
        graphics.method_25302(SIDE, middleX - 256 / 2 + 250, middleY - 80, 0, 0, 24, 180);

        // 绘制侧边的滚动条
        drawScrollSide(graphics, middleX, middleY);

        // 调用父类方法绘制按钮列表、标签列表
        drawButton(graphics, mouseX, mouseY, partialTicks);

        // 绘制标签栏图标
        drawTabIcon(graphics, middleX, middleY);

        // 绘制左边示例实体
        drawLeftEntity(graphics, middleX, middleY, mouseX, mouseY);

        // 绘制实体，绘制完毕后绘制文本提示
        drawEntity(graphics, middleX, middleY);

        // 绘制其他文本提示
        drawTooltips(graphics, mouseX, mouseY, middleX, middleY);
    }

    private void drawButton(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        for (class_4068 button : ((ScreenAccessor) this).tlm$getRenderables()) {
            button.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    private void drawScrollSide(class_332 graphics, int middleX, int middleY) {
        if (canScrollCurrentList()) {
            graphics.method_25302(SIDE, middleX - 256 / 2 + 254,
                    middleY - 61 + (int) (127 * getCurrentScrollPosition()),
                    24, 0, 12, 15);
        } else {
            graphics.method_25302(SIDE, middleX - 256 / 2 + 254,
                    middleY - 61 + (int) (127 * getCurrentScrollPosition()),
                    36, 0, 12, 15);
        }
    }

    private void drawTabIcon(class_332 graphics, int middleX, int middleY) {
        // 模型包的分栏按钮图标
        int size = guiNumber.getTabSize(getPackIndex());
        for (int index = 0; index < size; index++) {
            CustomModelPack<E> pack = modelPackList.get(guiNumber.tabToPackIndex(index, getPageIndex()));
            class_2960 icon = pack.getIcon();
            if (icon != null) {
                class_1044 iconTexture = class_310.method_1551().method_1531().method_34590(icon, EMPTY_ICON_TEXTURE);
                if (EMPTY_ICON_TEXTURE.equals(iconTexture)) {
                    icon = EMPTY_ICON;
                }
                if (pack.getIconAnimation() == CustomModelPack.AnimationState.UNCHECK) {
                    checkIconAnimation(pack, icon);
                }
                if (pack.getIconAnimation() == CustomModelPack.AnimationState.FALSE) {
                    graphics.method_25290(icon, middleX - 92 + 28 * index, middleY - 98,
                            0, 0, 16, 16, 16, 16);
                } else {
                    RenderSystem.setShader(class_757::method_34542);
                    RenderSystem.setShaderTexture(0, icon);
                    int time = getTickTime() / pack.getIconDelay();
                    int iconIndex = time % pack.getIconAspectRatio();
                    graphics.method_25290(icon, middleX - 92 + 28 * index, middleY - 98,
                            0, iconIndex * 16, 16,
                            16, 16, 16 * pack.getIconAspectRatio());
                }
            }
        }
    }

    private int getTickTime() {
        return (int) System.currentTimeMillis() / 50;
    }

    private void checkIconAnimation(CustomModelPack<E> pack, class_2960 icon) {
        class_1044 iconText = Screens.getClient(this).method_1531().method_4619(icon);
        if (iconText instanceof SizeTexture sizeTexture) {
            int width = sizeTexture.getWidth();
            int height = sizeTexture.getHeight();
            if (width >= height) {
                pack.setIconAnimation(CustomModelPack.AnimationState.FALSE);
            } else {
                pack.setIconAnimation(CustomModelPack.AnimationState.TRUE);
                pack.setIconAspectRatio(height / width);
            }
        } else {
            pack.setIconAnimation(CustomModelPack.AnimationState.FALSE);
        }
    }

    /**
     * 绘制所有的模型实体图案
     */
    private void drawEntity(class_332 graphics, int middleX, int middleY) {
        // 绘制包信息或搜索模式提示
        if (!isSearchMode) {
            // 获取当前包索引得到的模型列表
            CustomModelPack<E> pack = modelPackList.get(getPackIndex());
            // 绘制包信息
            drawPackInfoText(graphics, pack, middleX, middleY);
        }

        // 使用过滤后的列表
        List<E> displayList = getDisplayModelList();

        // 起始坐标
        int offsetX = -100;
        int offsetY = -38;

        // 切割列表，让其一页最多显示 55 个模型（11列 x 5行），但是又不至于溢出
        int fromIndex = guiNumber.modelFromIndex(getRowIndex());
        // 确保 fromIndex 不超出列表范围
        if (fromIndex >= displayList.size()) {
            return;
        }

        int toIndex = Math.min(
                fromIndex + 55,  // 每页最多显示 55 个模型（11列 x 5行）
                displayList.size()
        );

        // 开始绘制实体图案，并往上添加对应模型和材质
        for (E modelItem : displayList.subList(fromIndex, toIndex)) {
            drawRightEntity(graphics, middleX + offsetX, middleY + offsetY, modelItem);
            // 往右绘制
            offsetX = offsetX + 20;
            // 如果超出一定限制，换行
            if (offsetX > 105) {
                offsetX = -100;
                offsetY = offsetY + 30;
            }
        }
    }

    /**
     * 绘制包的文本信息
     */
    private void drawPackInfoText(class_332 graphics, CustomModelPack<E> pack, int middleX, int middleY) {
        int offsetY = -80;
        int sideMiddleX = (middleX - 256 / 2) / 2;

        // 绘制包名
        class_5250 packName = ParseI18n.parse(pack.getPackName());
        List<class_5348> packSplitName = field_22793.method_27527().method_27495(packName, (middleX - 256 / 2) - 20, class_2583.field_24360);
        for (class_5348 properties : packSplitName) {
            offsetY += 10;
            graphics.method_25300(field_22793, properties.getString(), sideMiddleX, middleY + offsetY, 0xffffff);
        }

        // 如果描述不为空，逐行绘制描述
        for (class_2561 str : ParseI18n.parse(pack.getDescription())) {
            List<class_5348> split = field_22793.method_27527().method_27495(str, (middleX - 256 / 2) - 20, class_2583.field_24360);
            for (class_5348 properties : split) {
                offsetY += 10;
                graphics.method_25300(field_22793, properties.getString(), sideMiddleX, middleY + offsetY, 0x777777);
            }
        }

        // 绘制作者列表
        if (!pack.getAuthor().isEmpty()) {
            for (List<String> textList : Lists.partition(pack.getAuthor(), 2)) {
                offsetY += 10;
                graphics.method_27534(field_22793, class_2561.method_43470(textList.toString()).method_27692(class_124.field_1065),
                        sideMiddleX, middleY + offsetY, 0xffffff);
            }
        }

        // 绘制版本信息
        if (pack.getVersion() != null) {
            offsetY += 10;
            graphics.method_27534(field_22793, class_2561.method_43469("gui.touhou_little_maid.skin.text.version", pack.getVersion())
                            .method_27692(class_124.field_1062),
                    sideMiddleX, middleY + offsetY, 0xffffff);
        }

        // 绘制日期信息
        if (pack.getDate() != null) {
            offsetY += 10;
            graphics.method_27534(field_22793, class_2561.method_43469("gui.touhou_little_maid.skin.text.date", pack.getDate())
                            .method_27692(class_124.field_1060),
                    sideMiddleX, middleY + offsetY, 0xffffff);
        }

        // 绘制最后的翻页数
        graphics.method_25300(field_22793, String.format("%s/%s", getPageIndex() + 1, guiNumber.getPageSize()), middleX, middleY - 118, 0xffffff);
    }

    /**
     * 绘制模型对应的文本提示<br>
     * 用遍历方式绘制文本提示，因为绝大多数情况下是空循环体（可能就涉及几个简单的 int 运算）<br>
     * 应该不会存在性能问题<br>
     */
    private void drawTooltips(class_332 graphics, int mouseX, int mouseY, int middleX, int middleY) {
        // 使用过滤后的列表
        List<E> displayList = getDisplayModelList();

        // 起始坐标
        int offsetX = -100;
        int offsetY = -35;

        // 切割列表，让其一页最多显示 55 个模型（11列 x 5行），但是又不至于溢出
        int fromIndex = guiNumber.modelFromIndex(getRowIndex());
        // 确保 fromIndex 不超出列表范围
        if (fromIndex < displayList.size()) {
            int toIndex = Math.min(
                    fromIndex + 55,  // 每页最多显示 55 个模型（11列 x 5行）
                    displayList.size()
            );

            // 开始绘制实体图案，并往上添加对应模型和材质
            for (E modelItem : displayList.subList(fromIndex, toIndex)) {
                // 判定鼠标所在的位置
                boolean isxInRange = middleX + offsetX - 8 < mouseX && mouseX < middleX + offsetX + 7;
                boolean isyInRange = middleY + offsetY - 23 < mouseY && mouseY < middleY + offsetY + 1;

                // 在位置内，就绘制文本提示
                if (isxInRange && isyInRange) {
                    // 绘制的文本
                    List<String> str = new ArrayList<>();
                    // 塞入模型名称
                    str.add(modelItem.getName());
                    // 塞入描述
                    str.addAll(modelItem.getDescription());
                    // 转换为 ITextComponent
                    List<class_2561> tooltips = ParseI18n.parse(str);
                    // 添加额外的提示
                    addModelCustomTips(modelItem, tooltips);
                    // 塞入提示语
                    if (!modelItem.getName().equals(ENCRYPT_EGG_NAME) && !modelItem.getName().equals(NORMAL_EGG_NAME)) {
                        tooltips.add(class_2561.method_43471("gui.touhou_little_maid.skin.tooltips.show_details")
                                .method_27692(class_124.field_1064));
                    }
                    // 当开启显示更多物品信息功能时，显示模型 ID
                    if (Screens.getClient(this).field_1690.field_1827) {
                        tooltips.add(class_2561.method_43470(modelItem.getModelId().toString()).method_27692(class_124.field_1063));
                    }
                    // 添加包名（搜索模式下需要查找模型所属的pack）
                    if (isSearchMode) {
                        CustomModelPack<E> modelPack = findPackForModel(modelItem);
                        if (modelPack != null) {
                            tooltips.add(ParseI18n.parse(modelPack.getPackName()).method_27692(class_124.field_1078));
                        }
                    } else {
                        CustomModelPack<E> pack = modelPackList.get(getPackIndex());
                        tooltips.add(ParseI18n.parse(pack.getPackName()).method_27692(class_124.field_1078));
                    }
                    // 绘制解析过的文本提示
                    graphics.method_51434(field_22793, tooltips, mouseX, mouseY);
                }
                // 往右绘制
                offsetX = offsetX + 20;

                // 如果超出一定限制，换行
                if (offsetX > 105) {
                    offsetX = -100;
                    offsetY = offsetY + 30;
                }
            }
        }

        // 绘制标签页的文本提示
        int size = guiNumber.getTabSize(getPackIndex());
        for (int index = 0; index < size; index++) {
            boolean isxInRange = middleX - 98 + 28 * index < mouseX && mouseX < middleX - 98 + 28 * index + 28;
            boolean isyInRange = middleY - 108 < mouseY && mouseY < middleY - 108 + 31;
            if (isxInRange && isyInRange) {
                CustomModelPack<E> hoverPack = modelPackList.get(guiNumber.tabToPackIndex(index, getPageIndex()));
                graphics.method_51438(field_22793, ParseI18n.parse(hoverPack.getPackName()), mouseX, mouseY);
            }
        }

        // 绘制关闭按钮的文本提示
        boolean xInRange = (middleX + 122) < mouseX && mouseX < (middleX + 143);
        boolean yInRange = (middleY - 97) < mouseY && mouseY < (middleY - 80);
        if (xInRange && yInRange) {
            graphics.method_51438(field_22793, class_2561.method_43471("gui.touhou_little_maid.skin.button.close"), mouseX, mouseY);
        }
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (deltaY != 0) {
            int index = 0;
            // 向上滚
            if (deltaY > 0) {
                index = 1;
            }
            // 向下滚
            if (deltaY < 0) {
                index = -1;
            }
            int row = class_3532.method_15340(getRowIndex() - index, 0, getDisplayRowSize());
            if (row != getRowIndex()) {
                setRowIndex(row);
                this.method_25426();
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        // 处理搜索框的点击事件
        if (this.searchBox != null && this.searchBox.method_25402(mouseX, mouseY, button)) {
            this.method_25395(this.searchBox);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        // 处理搜索框的键盘输入
        if (this.searchBox != null && this.searchBox.method_25370()) {
            if (this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25400(char codePoint, int modifiers) {
        // 处理搜索框的字符输入
        if (this.searchBox != null && this.searchBox.method_25370()) {
            if (this.searchBox.method_25400(codePoint, modifiers)) {
                return true;
            }
        }
        return super.method_25400(codePoint, modifiers);
    }

    /**
     * 搜索文本变化时的回调
     *
     * @param text 新的搜索文本
     */
    private void onSearchTextChanged(String text) {
        if (!this.searchText.equals(text)) {
            this.searchText = text;
            this.setRowIndex(0);
            this.method_25426();
        }
    }

    /**
     * 根据搜索文本更新过滤后的模型列表
     */
    private void updateFilteredModelList() {
        if (isSearchMode) {
            // 搜索模式下，从所有模型列表中过滤
            if (StringUtils.isBlank(searchText)) {
                // 无搜索文本时，显示所有模型
                filteredModelList = allModelsList;
            } else {
                // 有搜索文本时，从所有模型中过滤
                String lowerSearchText = searchText.toLowerCase(Locale.ENGLISH).trim();
                filteredModelList = allModelsList.stream()
                        .filter(model -> filterKeyWord(model, lowerSearchText))
                        .collect(Collectors.toList());
            }
        } else {
            // 非搜索模式下，置空
            filteredModelList = null;
        }
    }

    /**
     * 判断当前模型信息是否包含关键词。不区分大小写。
     *
     * @param model   模型
     * @param keyword 关键词
     */
    private boolean filterKeyWord(E model, String keyword) {
        // 先尝试匹配模型名
        String modelName = ParseI18n.getI18nValue(model.getName());
        if (modelName.toLowerCase(Locale.ENGLISH).contains(keyword)) {
            return true;
        }

        // 然后是描述
        for (String desc : model.getDescription()) {
            String descText = ParseI18n.getI18nValue(desc);
            if (descText.toLowerCase(Locale.ENGLISH).contains(keyword)) {
                return true;
            }
        }

        // 最后是 ID 匹配
        String modelId = model.getModelId().toString().toLowerCase(Locale.ENGLISH);
        return modelId.contains(keyword);
    }

    /**
     * 获取当前应该显示的模型列表（原始列表或过滤后的列表）
     *
     * @return 显示的模型列表
     */
    private List<E> getDisplayModelList() {
        if (isSearchMode) {
            // 搜索模式下，使用所有模型列表或过滤后的列表
            return Objects.requireNonNullElseGet(filteredModelList, () ->
                    Objects.requireNonNullElse(allModelsList, Collections.emptyList()));
        } else {
            // 正常模式下，使用当前包的模型列表或过滤后的列表
            return modelPackList.get(getPackIndex()).getModelList();
        }
    }

    /**
     * 获取当前显示列表的实际行数
     */
    private int getDisplayRowSize() {
        List<E> displayList = getDisplayModelList();
        if (displayList == null || displayList.isEmpty()) {
            return 0;
        }
        int row = (displayList.size() - 1) / 11 + 1;  // 11 是每行模型数
        return Math.max(row - 5, 0);  // 5 是可见行数，超过5行才能滚动
    }

    /**
     * 在所有pack中查找包含指定模型的pack
     *
     * @param model 要查找的模型
     * @return 包含该模型的pack，如果未找到则返回null
     */
    private CustomModelPack<E> findPackForModel(E model) {
        for (CustomModelPack<E> pack : modelPackList) {
            if (pack.getModelList().contains(model)) {
                return pack;
            }
        }
        return null;
    }

    /**
     * 判断当前列表是否可以滚动
     */
    private boolean canScrollCurrentList() {
        if (isSearchMode) {
            List<E> displayList = getDisplayModelList();
            int modelSize = displayList.size() - 11 * getRowIndex();
            return modelSize > 5 * 11;  // 超过55个（5行x11列）才能滚动
        } else {
            return guiNumber.canScroll(getPackIndex(), getRowIndex());
        }
    }

    /**
     * 获取当前滚动条位置（0.0-1.0）
     */
    private float getCurrentScrollPosition() {
        if (isSearchMode) {
            List<E> displayList = getDisplayModelList();
            if (displayList.isEmpty()) {
                return 0;
            }
            int totalRows = (displayList.size() - 1) / 11;
            int maxScroll = Math.max(totalRows - 4, 0);
            if (maxScroll == 0) {
                return 0;
            }
            return class_3532.method_15363((float) (getRowIndex() * (1.0 / maxScroll)), 0, 1);
        } else {
            return guiNumber.getCurrentScroll(getPackIndex(), getRowIndex());
        }
    }

    protected void onClickCloseButton() {
        this.method_25419();
    }
}
