package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoEntityRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.ILocationModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import java.util.Objects;
import net.minecraft.class_1088;
import net.minecraft.class_1308;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2185;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5253;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_9307;
import net.minecraft.class_9334;

import static com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader.MAID_BANNER;

public class GeckoLayerMaidBanner<T extends class_1308, R extends IGeoEntityRenderer<T>> extends GeoLayerRenderer<T, R> {
    private static final class_2960 TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/bedrock/entity/maid_banner.png");
    private final SimpleBedrockModel<EntityMaid> bannerModel;
    private final class_5599 modelSet;
    private final class_630 flag;

    public GeckoLayerMaidBanner(R renderer, class_5599 modelSet) {
        super(renderer);
        this.modelSet = modelSet;
        this.bannerModel = Objects.requireNonNull(BedrockModelLoader.getModel(MAID_BANNER));
        this.flag = modelSet.method_32072(class_5602.field_27678).method_32086("flag");
    }

    @Override
    public GeoLayerRenderer<T, R> copy(R entityRendererIn) {
        return new GeckoLayerMaidBanner<>(entityRendererIn, modelSet);
    }

    @Override
    public void render(class_4587 poseStack, class_4597 bufferIn, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        EntityMaid maid = IMaid.convertToMaid(entity);
        if (maid == null || !(maid.getBackpackShowItem().method_7909() instanceof class_1746 bannerItem)) {
            return;
        }
        if (!getGeoEntity(entity).getMaidInfo().isShowBackpack() || entity.method_6113() || entity.method_5767()) {
            return;
        }
        if (!maid.getConfigManager().isShowBackItem()) {
            return;
        }
        ILocationModel geoModel = getLocationModel(entity);
        if (geoModel != null && !geoModel.backpackBones().isEmpty()) {
            poseStack.method_22903();
            RenderUtils.prepMatrixForLocator(poseStack, geoModel.backpackBones());
            poseStack.method_22904(0, 0.75, 0.3);
            poseStack.method_22905(0.65F, -0.65F, -0.65F);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(180));
            poseStack.method_22907(class_7833.field_40713.rotationDegrees(5));
            class_4588 buffer = bufferIn.getBuffer(class_1921.method_23572(TEXTURE));
            this.bannerModel.method_60879(poseStack, buffer, packedLight, class_4608.field_21444);
            class_9307 patterns = maid.getBackpackShowItem().method_57824(class_9334.field_49619);
            class_1767 dyeColor = ((class_2185) bannerItem.method_7711()).method_9303();
            if (patterns != null) {
                renderPatterns(poseStack, bufferIn, packedLight, bannerModel.getPart("banner"), patterns, dyeColor);
            }
            poseStack.method_22909();
        }
    }

    private void renderPatterns(class_4587 poseStack, class_4597 bufferSource, int packedLight,
                                BedrockPart banner, class_9307 patterns, class_1767 dyeColor) {
        banner.render(poseStack, class_1088.field_20847.method_30001(bufferSource, class_1921::method_23572, false),
                packedLight, class_4608.field_21444);
        renderPatternLayer(poseStack, bufferSource, packedLight, banner, class_4722.field_49769, dyeColor);
        for (int i = 0; i < 16 && i < patterns.comp_2428().size(); ++i) {
            class_9307.class_9308 layer = patterns.comp_2428().get(i);
            class_4730 material = class_4722.method_33081(layer.comp_2429());
            renderPatternLayer(poseStack, bufferSource, packedLight, banner, material, layer.comp_2430());
        }
    }

    private void renderPatternLayer(class_4587 poseStack, class_4597 buffer, int packedLight, BedrockPart banner, class_4730 material, class_1767 color) {
        int packedColor = color.method_7787();
        float red = class_5253.class_5254.method_27765(packedColor) / 255f;
        float green = class_5253.class_5254.method_27766(packedColor) / 255f;
        float blue = class_5253.class_5254.method_27767(packedColor) / 255f;
        banner.render(poseStack, material.method_24145(buffer, class_1921::method_23588), packedLight, class_4608.field_21444, red, green, blue, 1.0F);
    }
}