package com.github.tartaricacid.touhoulittlemaid.compat.emi;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.compat.emi.altar.EmiAltarRecipeCategory;
import com.github.tartaricacid.touhoulittlemaid.compat.emi.altar.EmiAltarRecipeMaker;
import com.github.tartaricacid.touhoulittlemaid.compat.emi.transfer.BackpackRecipeHandler;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.CraftingTableBackpackContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.FurnaceBackpackContainer;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_768;

@EmiEntrypoint
public class MaidEmiPlugin implements EmiPlugin {
    public static final EmiRecipeCategory ALTAR = new EmiAltarRecipeCategory();

    private void registerAltarRecipeCategory(EmiRegistry registry) {
        registry.addCategory(ALTAR);
        registry.addWorkstation(ALTAR, EmiStack.of(InitItems.HAKUREI_GOHEI));
        registry.addWorkstation(ALTAR, EmiStack.of(InitItems.SANAE_GOHEI));

        EmiAltarRecipeMaker.registerAltarRecipes(registry);
    }

    /**
     * 用来隐藏过多的手办和坐垫
     */
    private void hideStacks(EmiRegistry registry) {
        List<class_1799> groupItems = new ArrayList<>();
        groupItems.add(InitItems.GARAGE_KIT.method_7854());
        groupItems.add(InitItems.CHAIR.method_7854());

        // 先干掉所有手办和坐垫
        registry.removeEmiStacks(emiStack -> {
            class_1799 itemStack = emiStack.getItemStack();
            for (class_1799 groupItem : groupItems) {
                if (itemStack.method_31574(groupItem.method_7909()) && !class_1799.method_7973(groupItem, itemStack)) {
                    return true;
                }
            }
            return false;
        });

        // 再各自添加一个回去
        for (class_1799 item : groupItems) {
            registry.addEmiStackAfter(EmiStack.of(item), emiStack -> emiStack.getItemStack().method_31574(InitItems.POWER_POINT));
        }
    }

    private void registerRecipeHandlers(EmiRegistry registry) {
        registry.addRecipeHandler(CraftingTableBackpackContainer.TYPE, new BackpackRecipeHandler<>(VanillaEmiRecipeCategories.CRAFTING, 71, 9, 0, 70));
        registry.addRecipeHandler(FurnaceBackpackContainer.TYPE, new BackpackRecipeHandler<>(VanillaEmiRecipeCategories.SMELTING, 70, 1, 0, 70));
        registry.addRecipeHandler(FurnaceBackpackContainer.TYPE, new BackpackRecipeHandler<>(VanillaEmiRecipeCategories.FUEL, 71, 1, 0, 70));
    }

    private void registerExclusionArea(EmiRegistry registry) {
        registry.addGenericExclusionArea(((screen, consumer) -> {
            if (!(screen instanceof AbstractMaidContainerGui<?> maidContainerGui)) {
                return;
            }
            for (class_768 rect2i : maidContainerGui.getExclusionArea()) {
                consumer.accept(new Bounds(rect2i.method_3321(), rect2i.method_3322(), rect2i.method_3319(), rect2i.method_3320()));
            }
        }));
    }

    private void registerInfoRecipe(EmiRegistry registry) {
        registry.addRecipe(getInfoRecipe(InitItems.GARAGE_KIT, class_2561.method_43471("jei.touhou_little_maid.garage_kit.info")));
    }

    private EmiInfoRecipe getInfoRecipe(class_1792 item, class_2561 component) {
        return new EmiInfoRecipe(List.of(EmiStack.of(item)), List.of(component), null);
    }

    @Override
    public void register(EmiRegistry registry) {
        registerAltarRecipeCategory(registry);
        registerRecipeHandlers(registry);
        registerExclusionArea(registry);
        registerInfoRecipe(registry);
        hideStacks(registry);
    }
}