package com.github.tartaricacid.touhoulittlemaid.compat.gun.common.ai;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.GunCommonUtil;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class GunShootTargetTask extends class_4097<EntityMaid> {
    private int attackCooldown = -1;
    private int seeTime;

    public GunShootTargetTask() {
        super(ImmutableMap.of(class_4140.field_18446, class_4141.field_18458, class_4140.field_22355, class_4141.field_18456), 1200);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        if (!GunCommonUtil.isGun(owner.method_6047())) {
            return false;
        }
        return owner.method_18868().method_18904(class_4140.field_22355).filter(owner::canSee).isPresent();
    }

    @Override
    protected boolean canStillUse(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        return entityIn.method_18868().method_18896(class_4140.field_22355) && this.checkExtraStartConditions(worldIn, entityIn);
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    @Override
    protected void tick(class_3218 worldIn, EntityMaid owner, long gameTime) {
        owner.method_18868().method_18904(class_4140.field_22355).ifPresent((target) -> {
            // 实际上按照原版mc判定是看不见的，强行看见并朝向（没关就是开了？）
            owner.method_5988().method_20248(target.method_23317(), target.method_23318(), target.method_23321());
            boolean canSee = owner.canSee(target);
            boolean seeTimeMoreThanZero = this.seeTime > 0;

            // 如果两者不一致，重置看见时间
            if (canSee != seeTimeMoreThanZero) {
                this.seeTime = 0;
            }
            // 如果看见了对方，增加看见时间，否则减少
            if (canSee) {
                ++this.seeTime;
            } else {
                --this.seeTime;
            }

            class_1799 mainHandItem = owner.method_6047();
            GunCommonUtil.tick(owner, target, mainHandItem);

            // 如果实体手部处于激活状态
            if (--this.attackCooldown <= 0 && this.seeTime >= -60 && canSee) {
                try {
                    // 由于部分枪包作者可能在写 lua 脚本时没有规范书写，导致 lua 脚本抛出异常
                    // 所以这里捕获异常，避免因为 lua 脚本错误导致游戏崩溃
                    this.attackCooldown = GunCommonUtil.performGunAttack(owner, target, mainHandItem);
                } catch (Exception e) {
                    TouhouLittleMaid.LOGGER.error("Error while performing gun attack for EntityMaid: {}", owner.method_5667(), e);
                    // 如果发生异常，重置攻击冷却时间
                    this.attackCooldown = 100;
                }
            }
        });
    }

    public void setAttackCooldown(int attackCooldown) {
        this.attackCooldown = attackCooldown;
    }

    @Override
    protected void stop(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        this.seeTime = 0;
        this.attackCooldown = -1;
        maid.setSwingingArms(false);
        maid.setAiming(false);
        // 停止
        GunCommonUtil.onStop(maid, this);
    }
}