package com.github.tartaricacid.touhoulittlemaid.datagen;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.block.BlockMaidBed;
import com.github.tartaricacid.touhoulittlemaid.block.BlockScarecrow;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.loot.RandomBoardStateFunction;
import com.github.tartaricacid.touhoulittlemaid.loot.SetTankCountFunction;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.SimpleFabricLootTableProvider;
import net.minecraft.class_109;
import net.minecraft.class_141;
import net.minecraft.class_149;
import net.minecraft.class_173;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2960;
import net.minecraft.class_3612;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_7225;
import net.minecraft.class_73;
import net.minecraft.class_77;
import net.minecraft.class_7924;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class LootTableGenerator {
    public static final class_5321<class_52> GIVE_SMART_SLAB = getLootTableKey("give_smart_slab");

    public static final class_5321<class_52> ADVANCEMENT_POWER_POINT = getLootTableKey("advancement/power_point");
    public static final class_5321<class_52> CAKE = getLootTableKey("advancement/cake");

    public static final class_5321<class_52> CHEST_POWER_POINT = getLootTableKey("chest/power_point");
    public static final class_5321<class_52> FISHING_POWER_POINT = getLootTableKey("fishing/power_point");

    public static final class_5321<class_52> SHRINE_LESS = getLootTableKey("chest/shrine_less");
    public static final class_5321<class_52> SHRINE_MORE = getLootTableKey("chest/shrine_more");

    public static final class_5321<class_52> SPAWN_BONUS = getLootTableKey("chest/spawn_bonus");
    public static final class_5321<class_52> NORMAL_BACKPACK = getLootTableKey("chest/normal_backpack");
    public static final class_5321<class_52> FURNACE_OR_CRAFTING_TABLE_BACKPACK = getLootTableKey("chest/furnace_or_crafting_table_backpack");
    public static final class_5321<class_52> TANK_BACKPACK = getLootTableKey("chest/tank_backpack");
    public static final class_5321<class_52> ENDER_CHEST_BACKPACK = getLootTableKey("chest/ender_chest_backpack");

    public static final class_5321<class_52> NORMAL_BAUBLE = getLootTableKey("chest/normal_bauble");
    public static final class_5321<class_52> RARE_BAUBLE = getLootTableKey("chest/rare_bauble");
    public static final class_5321<class_52> VERY_RARE_BAUBLE = getLootTableKey("chest/very_rare_bauble");

    public static final class_5321<class_52> STRUCTURE_SPAWN_MAID_GIFT = getLootTableKey("chest/structure_spawn_maid_gift");
    public static final class_5321<class_52> MAID_BURIED_TREASURE = getLootTableKey("chest/maid_buried_treasure");

    public static final class_5321<class_52> RANDOM_BOARD_STATE = getLootTableKey("chest/random_board_state");

    public static class_5321<class_52> getLootTableKey(String name) {
        return class_5321.method_29179(class_7924.field_50079, class_2960.method_60655(TouhouLittleMaid.MOD_ID, name));
    }

    public static class ChestLootTables extends SimpleFabricLootTableProvider {
        private final class_7225.class_7874 registries;

        public ChestLootTables(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(output, registryLookup, class_173.field_1179);
            this.registries = registryLookup.join();
        }

        @Override
        public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> consumer) {
            consumer.accept(CHEST_POWER_POINT, class_52.method_324().method_336(class_55.method_347()
                    .method_352(class_44.method_32448(1))
                    .method_351(class_77.method_411(InitItems.POWER_POINT)
                            .method_438(class_141.method_621(class_5662.method_32462(1, 2))))
                    .method_351(class_73.method_401().method_437(2))));

            consumer.accept(FISHING_POWER_POINT, class_52.method_324().method_336(class_55.method_347()
                    .method_352(class_44.method_32448(1))
                    .method_351(class_77.method_411(InitItems.POWER_POINT))
                    .method_351(class_73.method_401().method_437(9))));

            consumer.accept(SHRINE_LESS, class_52.method_324().method_336(class_55.method_347()
                    .method_352(class_44.method_32448(1))
                    .method_351(class_77.method_411(InitItems.SHRINE))
                    .method_351(class_73.method_401().method_437(9))));

            consumer.accept(SHRINE_MORE, class_52.method_324().method_336(class_55.method_347()
                    .method_352(class_44.method_32448(1))
                    .method_351(class_77.method_411(InitItems.SHRINE))
                    .method_351(class_73.method_401().method_437(2))));

            consumer.accept(SPAWN_BONUS, class_52.method_324()
                    .method_336(class_55.method_347()
                            .method_352(class_44.method_32448(1))
                            .method_351(class_77.method_411(InitItems.MAID_BACKPACK_SMALL).method_437(3))
                            .method_351(class_77.method_411(InitItems.MAID_BACKPACK_MIDDLE).method_437(9))
                            .method_351(class_77.method_411(InitItems.MAID_BACKPACK_BIG).method_437(4)))
                    .method_336(class_55.method_347()
                            .method_352(class_44.method_32448(1))
                            .method_351(class_77.method_411(InitItems.POWER_POINT)
                                    .method_438(class_141.method_621(class_5662.method_32462(3, 9))))
                    ));

            consumer.accept(NORMAL_BACKPACK, class_52.method_324().method_336(class_55.method_347()
                    .method_352(class_44.method_32448(1))
                    .method_351(class_77.method_411(InitItems.MAID_BACKPACK_SMALL).method_437(3))
                    .method_351(class_77.method_411(InitItems.MAID_BACKPACK_MIDDLE).method_437(9))
                    .method_351(class_77.method_411(InitItems.MAID_BACKPACK_BIG).method_437(4))
                    .method_351(class_73.method_401().method_437(50))));

            consumer.accept(FURNACE_OR_CRAFTING_TABLE_BACKPACK, class_52.method_324().method_336(class_55.method_347()
                    .method_352(class_44.method_32448(1))
                    .method_351(class_77.method_411(InitItems.FURNACE_BACKPACK))
                    .method_351(class_77.method_411(InitItems.CRAFTING_TABLE_BACKPACK))
                    .method_351(class_73.method_401().method_437(8))));

            var tank1 = class_77.method_411(InitItems.TANK_BACKPACK).method_438(new SetTankCountFunction.Builder(class_3612.field_15908, 9));
            var tank2 = class_77.method_411(InitItems.TANK_BACKPACK).method_438(new SetTankCountFunction.Builder(class_3612.field_15908, 4));
            var tank3 = class_77.method_411(InitItems.TANK_BACKPACK).method_438(new SetTankCountFunction.Builder(class_3612.field_15908, 3));

            consumer.accept(TANK_BACKPACK, class_52.method_324().method_336(class_55.method_347()
                    .method_352(class_44.method_32448(1))
                    .method_351(tank1).method_351(tank2).method_351(tank3)
                    .method_351(class_73.method_401().method_437(12))));

            consumer.accept(ENDER_CHEST_BACKPACK, class_52.method_324().method_336(class_55.method_347()
                    .method_352(class_44.method_32448(1))
                    .method_351(class_77.method_411(InitItems.ENDER_CHEST_BACKPACK).method_437(1))
                    .method_351(class_73.method_401().method_437(4))));

            consumer.accept(NORMAL_BAUBLE, class_52.method_324().method_336(class_55.method_347()
                    .method_352(class_5662.method_32462(1, 3))
                    // 有附魔的饰品
                    .method_351(class_77.method_411(InitItems.EXPLOSION_PROTECT_BAUBLE).method_438(class_109.method_489(this.registries)))
                    .method_351(class_77.method_411(InitItems.FIRE_PROTECT_BAUBLE).method_438(class_109.method_489(this.registries)))
                    .method_351(class_77.method_411(InitItems.PROJECTILE_PROTECT_BAUBLE).method_438(class_109.method_489(this.registries)))
                    .method_351(class_77.method_411(InitItems.MAGIC_PROTECT_BAUBLE).method_438(class_109.method_489(this.registries)))
                    .method_351(class_77.method_411(InitItems.FALL_PROTECT_BAUBLE).method_438(class_109.method_489(this.registries)))
                    .method_351(class_77.method_411(InitItems.DROWN_PROTECT_BAUBLE).method_438(class_109.method_489(this.registries)))
                    // 没有附魔的饰品
                    .method_351(class_77.method_411(InitItems.EXPLOSION_PROTECT_BAUBLE).method_437(4))
                    .method_351(class_77.method_411(InitItems.FIRE_PROTECT_BAUBLE).method_437(4))
                    .method_351(class_77.method_411(InitItems.PROJECTILE_PROTECT_BAUBLE).method_437(4))
                    .method_351(class_77.method_411(InitItems.MAGIC_PROTECT_BAUBLE).method_437(4))
                    .method_351(class_77.method_411(InitItems.FALL_PROTECT_BAUBLE).method_437(4))
                    .method_351(class_77.method_411(InitItems.DROWN_PROTECT_BAUBLE).method_437(4))
                    // 其他
                    .method_351(class_73.method_401().method_437(90))));

            consumer.accept(RARE_BAUBLE, class_52.method_324().method_336(class_55.method_347()
                    .method_352(class_5662.method_32462(1, 2))
                    .method_351(class_77.method_411(InitItems.NIMBLE_FABRIC).method_438(class_109.method_489(this.registries)))
                    .method_351(class_77.method_411(InitItems.NIMBLE_FABRIC))
                    .method_351(class_77.method_411(InitItems.ITEM_MAGNET_BAUBLE))
                    .method_351(class_73.method_401().method_437(6))));

            consumer.accept(VERY_RARE_BAUBLE, class_52.method_324().method_336(class_55.method_347()
                    .method_352(class_44.method_32448(1))
                    .method_351(class_77.method_411(InitItems.ULTRAMARINE_ORB_ELIXIR).method_438(class_109.method_489(this.registries)))
                    .method_351(class_77.method_411(InitItems.ULTRAMARINE_ORB_ELIXIR).method_437(2))
                    .method_351(class_73.method_401().method_437(4))));

            var setDamage = class_149.method_633(class_5662.method_32462(0.06f, 0.1f));
            consumer.accept(STRUCTURE_SPAWN_MAID_GIFT, class_52.method_324()
                    .method_336(class_55.method_347()
                            .method_352(class_5662.method_32462(1, 2))
                            .method_351(class_77.method_411(class_1802.field_17534)))
                    .method_336(class_55.method_347()
                            .method_352(class_44.method_32448(1))
                            .method_351(class_77.method_411(InitItems.CAMERA).method_438(setDamage))));

            consumer.accept(MAID_BURIED_TREASURE, class_52.method_324()
                    .method_336(class_55.method_347()
                            .method_352(class_44.method_32448(1))
                            .method_351(class_77.method_411(InitItems.SMART_SLAB_EMPTY))
                            .method_351(class_73.method_401().method_437(4)))
                    .method_336(class_55.method_347()
                            .method_352(class_44.method_32448(1))
                            .method_351(class_77.method_411(InitItems.SHRINE))
                            .method_351(class_73.method_401())));

            var library = RandomBoardStateFunction.create().addTag("library");
            consumer.accept(RANDOM_BOARD_STATE, class_52.method_324()
                    .method_336(class_55.method_347()
                            .method_352(class_44.method_32448(1))
                            .method_351(class_77.method_411(InitItems.GOMOKU_BOARD_STATE).method_438(library))
                            .method_351(class_77.method_411(InitItems.CCHESS_BOARD_STATE).method_438(library))
                            .method_351(class_77.method_411(InitItems.WCHESS_BOARD_STATE).method_438(library))));
        }
    }

    public static class AdvancementLootTables extends SimpleFabricLootTableProvider {
        public AdvancementLootTables(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(output, registryLookup, class_173.field_1174);
        }

        @Override
        public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> consumer) {
            consumer.accept(GIVE_SMART_SLAB, class_52.method_324()
                    .method_336(class_55.method_347()
                            .method_352(class_44.method_32448(1))
                            .method_351(class_77.method_411(InitItems.SMART_SLAB_INIT))));

            consumer.accept(ADVANCEMENT_POWER_POINT, class_52.method_324().method_336(class_55.method_347()
                    .method_352(class_44.method_32448(5))
                    .method_351(class_77.method_411(InitItems.POWER_POINT))));

            consumer.accept(CAKE, class_52.method_324().method_336(class_55.method_347()
                    .method_352(class_44.method_32448(1))
                    .method_351(class_77.method_411(class_1802.field_17534))));
        }
    }

    public static class EntityLootTables extends SimpleFabricLootTableProvider {
        public EntityLootTables(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(output, registryLookup, class_173.field_1173);
        }

        @Override
        public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> consumer) {
            consumer.accept(InitEntities.BOX.method_16351(), class_52.method_324().method_336(class_55.method_347()
                    .method_352(class_44.method_32448(1))
                    .method_351(class_77.method_411(class_1802.field_8407))));
        }
    }

    public static class BlockLootTables extends FabricBlockLootTableProvider {
        public final Set<class_2248> knownBlocks = new HashSet<>();

        protected BlockLootTables(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }


        @Override
        public void method_10379() {
            method_45994(InitBlocks.MAID_BED, block -> method_45987(block, BlockMaidBed.PART, class_2742.field_12560));
            method_45994(InitBlocks.SCARECROW, block -> method_45987(block, BlockScarecrow.HALF, class_2756.field_12607));

            method_46025(InitBlocks.MODEL_SWITCHER);
            method_46025(InitBlocks.KEYBOARD);
            method_46025(InitBlocks.BOOKSHELF);
            method_46025(InitBlocks.COMPUTER);
            method_46025(InitBlocks.SHRINE);
        }

        @Override
        public void method_45988(class_2248 block, class_52.class_53 builder) {
            this.knownBlocks.add(block);
            super.method_45988(block, builder);
        }
    }
}