package com.github.tartaricacid.touhoulittlemaid.datagen.builder;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import javax.annotation.Nullable;
import net.minecraft.class_1299;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7710;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_8790;

public class AltarRecipeBuilder implements class_5797 {
    private static final String NAME = "altar_recipe";
    private final class_7800 category;
    private final class_1792 result;
    private final class_2371<class_1856> ingredients;
    private final class_1799 resultStack;
    private float power;
    private class_2960 entityType;
    private String langKey;

    public AltarRecipeBuilder(class_7800 recipeCategory, class_1935 resultStack, int count) {
        this(recipeCategory, new class_1799(resultStack, count));
    }

    public AltarRecipeBuilder(class_7800 recipeCategory, class_1799 result) {
        this.category = recipeCategory;
        this.power = 0;
        this.result = result.method_7909();
        this.resultStack = result;
        this.entityType = class_7923.field_41177.method_10221(class_1299.field_6052);
        this.ingredients = class_2371.method_10211();
        this.langKey = "jei.touhou_little_maid.altar_craft.item_craft.result";
    }

    public static AltarRecipeBuilder shapeless(class_7800 category, class_1799 result) {
        return new AltarRecipeBuilder(category, result);
    }

    public static AltarRecipeBuilder shapeless(class_7800 category, class_1935 result) {
        return shapeless(category, result, 1);
    }

    public static AltarRecipeBuilder shapeless(class_7800 category, class_1935 result, int count) {
        return new AltarRecipeBuilder(category, result, count);
    }

    public AltarRecipeBuilder requires(class_6862<class_1792> tag) {
        return this.requires(class_1856.method_8106(tag));
    }

    public AltarRecipeBuilder requires(int count, class_6862<class_1792> tag) {
        return this.requires(class_1856.method_8106(tag), count);
    }

    public AltarRecipeBuilder requires(class_1935 item) {
        return this.requires(1, item);
    }

    public AltarRecipeBuilder requires(int quantity, class_1935 item) {
        for (int i = 0; i < quantity; ++i) {
            this.requires(class_1856.method_8091(item));
        }
        return this;
    }

    public AltarRecipeBuilder requires(class_1856 ingredient) {
        return this.requires(ingredient, 1);
    }

    public AltarRecipeBuilder requires(class_1856 ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public AltarRecipeBuilder power(float power) {
        this.power = power;
        return this;
    }

    public AltarRecipeBuilder entity(class_2960 entityType) {
        this.entityType = entityType;
        return this;
    }

    public AltarRecipeBuilder langKey(String langKey) {
        this.langKey = langKey;
        return this;
    }

    @Override
    public AltarRecipeBuilder method_33530(String name, class_175<?> criterion) {
        return this;
    }

    @Override
    public AltarRecipeBuilder method_33529(@Nullable String groupName) {
        return this;
    }

    @Override
    public class_1792 method_36441() {
        return this.result;
    }

    @Override
    public void method_10431(class_8790 output) {
        String path = class_5797.method_36442(this.method_36441()).method_12832();
        class_2960 filePath = class_2960.method_60655(TouhouLittleMaid.MOD_ID, NAME + "/" + path);
        this.method_17972(output, filePath);
    }

    @Override
    public void method_36443(class_8790 output, String recipeId) {
        class_2960 filePath = class_2960.method_60655(TouhouLittleMaid.MOD_ID, NAME + "/" + recipeId);
        this.method_17972(output, filePath);
    }

    @Override
    public void method_17972(class_8790 recipeOutput, class_2960 id) {
        class_7710 bookCategory = class_5797.method_55308(this.category);
        AltarRecipe altarRecipe = new AltarRecipe(NAME, bookCategory, this.ingredients, this.power, this.resultStack, this.entityType, this.langKey);
        recipeOutput.method_53819(id, altarRecipe, null);
    }
}
