package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class MaidPickupEntitiesTask extends class_4097<EntityMaid> {
    private static long GLOBAL_NEXT_SCHEDULE_AT = 0;

    private final Predicate<EntityMaid> predicate;
    private final float speedModifier;
    private long nextScheduledAt = 0;

    public MaidPickupEntitiesTask(float speedModifier) {
        this(Predicates.alwaysTrue(), speedModifier);
    }

    public MaidPickupEntitiesTask(Predicate<EntityMaid> predicate, float speedModifier) {
        super(ImmutableMap.of(InitEntities.VISIBLE_PICKUP_ENTITIES, class_4141.field_18456,
                class_4140.field_18445, class_4141.field_18457));
        this.predicate = predicate;
        this.speedModifier = speedModifier;
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        return owner.method_6181() && nextScheduledAt <= class_156.method_658() && owner.canBrainMoving() && predicate.test(owner);
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        List<class_1297> items = this.getItems(maid);
        var pathFinding = new MaidPathFindingBFS(maid.method_5942().method_6342(), worldIn, maid);
        long millis = class_156.method_658();
        // 在不同的女仆的拾取任务之间对齐时间间隔，来尽可能发挥相邻点缓存的作用
        nextScheduledAt = GLOBAL_NEXT_SCHEDULE_AT;
        if (millis >= nextScheduledAt) {
            // 如果没有其他女仆的拾取计划，那么安排在三秒后
            GLOBAL_NEXT_SCHEDULE_AT = millis + 3000;
            nextScheduledAt = GLOBAL_NEXT_SCHEDULE_AT;
        }
        for (class_1297 entity : items) {
            class_2338 blockPos = entity.method_24515();
            if (maid.method_18407(blockPos)
                    && entity.method_5805()
                    && !entity.method_5799()
                    && pathFinding.canPathReach(blockPos)) {
                class_4215.method_24557(maid, entity, this.speedModifier, 0);
                // 如果成功，那么下一次计划立刻进行，方便进行连续拾取
                nextScheduledAt = 0;
                break;
            }
        }
        pathFinding.finish();
    }

    private List<class_1297> getItems(EntityMaid maid) {
        return maid.method_18868().method_18904(InitEntities.VISIBLE_PICKUP_ENTITIES).orElse(Lists.newArrayList());
    }
}