package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import net.minecraft.class_5147;
import net.minecraft.class_6670;

public class MaidShearTask extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 12;
    private final float speedModifier;
    private class_1309 shearableEntity = null;

    public MaidShearTask(float speedModifier) {
        super(ImmutableMap.of(class_4140.field_18442, class_4141.field_18456,
                class_4140.field_18445, class_4141.field_18457));
        this.speedModifier = speedModifier;
        this.setMaxCheckRate(MAX_DELAY_TIME);
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        class_1799 mainHandItem = maid.method_6047();
        shearableEntity = null;

        if (!(mainHandItem.method_7909() instanceof class_1820)) {
            return;
        }

        this.getEntities(maid)
                .method_38980(e -> maid.method_18407(e.method_24515()))
                .filter(class_1297::method_5805)
                .filter(e -> e instanceof class_5147 /*IShearable*/)
                //.filter(e -> ((IShearable) e).isShearable(null, mainHandItem, maid.level(), e.blockPosition()))
                .filter(e -> ((class_5147) e).method_27072())
                .filter(maid::canPathReach)
                .findFirst()
                .ifPresent(e -> {
                    shearableEntity = e;
                    class_4215.method_24557(maid, e, this.speedModifier, 0);
                });

        if (shearableEntity != null && shearableEntity.method_24516(maid, 2)) {
/*            RandomSource rand = maid.getRandom();
            List<ItemStack> drops = ((IShearable) shearableEntity).onSheared(null, mainHandItem,
                    maid.level(), shearableEntity.blockPosition());
            drops.forEach(stack -> {
                ItemEntity itemEntity = shearableEntity.spawnAtLocation(stack, 1.0F);
                if (itemEntity != null) {
                    itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add(
                            (rand.nextFloat() - rand.nextFloat()) * 0.1F,
                            rand.nextFloat() * 0.05F,
                            (rand.nextFloat() - rand.nextFloat()) * 0.1F));
                }
            });*/

            // Fabric:
            ((class_5147) shearableEntity).method_6636(class_3419.field_15245);

            maid.method_6104(class_1268.field_5808);
            mainHandItem.method_7970(1, maid, class_1304.field_6173);
            shearableEntity = null;
        }
    }

    private class_6670 getEntities(EntityMaid maid) {
        return maid.method_18868().method_18904(class_4140.field_18442).orElse(class_6670.method_38971());
    }
}
