package com.github.tartaricacid.touhoulittlemaid.entity.ai.path;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;
import net.minecraft.class_11;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_8;

/**
 * 水下的时候让女仆选择合适的路径计算器，使用不同的启发函数进行寻路
 * 如果目标是上岸，则对 Y 差值给出额外的开销，来减少向下搜索的数量
 */
public class MaidSelectivePathFinding extends MaidWrappedPathFinder {
    private final MaidUnderWaterBoardingPathFinder boarding;
    private final class_1922 level;

    public MaidSelectivePathFinding(class_8 nodeEvaluator, int maxVisitedNodes, class_1922 level) {
        super(nodeEvaluator, maxVisitedNodes);
        this.level = level;
        this.boarding = new MaidUnderWaterBoardingPathFinder(nodeEvaluator, maxVisitedNodes);
    }

    @Nullable
    @Override
    public class_11 method_52(@NotNull class_1950 region, @NotNull class_1308 mob, Set<class_2338> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
        if (targetPositions.stream().anyMatch(p -> level.method_8316(p).method_15769())) {
            return boarding.method_52(region, mob, targetPositions, maxRange, accuracy, searchDepthMultiplier);
        }
        return super.method_52(region, mob, targetPositions, maxRange, accuracy, searchDepthMultiplier);
    }
}