package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.TextChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.WaitingChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

import static com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData.DEFAULT_PRIORITY;
import static com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData.TYPE_2;
import static com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid.getChatBubbleKey;

public class ChatBubbleManager {
    private final EntityMaid maid;

    public ChatBubbleManager(EntityMaid maid) {
        this.maid = maid;
    }

    public void tick() {
        // 随机添加表情
        RandomEmoji.tick(maid);
        // 每 5 tick 检查一次
        if (this.maid.field_6012 % 5 != 0) {
            return;
        }
        boolean update = this.getChatBubbleDataCollection().update();
        if (update) {
            this.forceUpdateChatBubble();
        }
    }

    public ChatBubbleDataCollection getChatBubbleDataCollection() {
        return maid.method_5841().method_12789(getChatBubbleKey());
    }

    @Nullable
    public IChatBubbleData getChatBubble(long key) {
        return this.getChatBubbleDataCollection().get(key);
    }

    public void removeChatBubble(long key) {
        this.getChatBubbleDataCollection().remove(key);
        this.forceUpdateChatBubble();
    }

    public void forceUpdateChatBubble() {
        maid.method_5841().method_49743(getChatBubbleKey(), this.getChatBubbleDataCollection(), true);
    }

    /**
     * 返回存入的 key
     *
     * @param bubble 聊天气泡
     * @return 如果存入失败则返回 -1
     */
    public long addChatBubble(IChatBubbleData bubble) {
        long key = this.getChatBubbleDataCollection().add(bubble);
        this.forceUpdateChatBubble();
        return key;
    }

    public long addTextChatBubble(String langKey) {
        class_5250 component = class_2561.method_43471(langKey);
        return this.addChatBubble(TextChatBubbleData.type2(component));
    }

    /**
     * 只有在前一个聊天气泡超时后才会添加新的聊天气泡
     */
    public long addTextChatBubbleIfTimeout(String langKey, long previousChatBubbleId) {
        ChatBubbleDataCollection collection = this.getChatBubbleDataCollection();
        if (previousChatBubbleId < 0 || !collection.containsKey(previousChatBubbleId)) {
            return addTextChatBubble(langKey);
        }
        return previousChatBubbleId;
    }

    public long addThinkingText(String langKey) {
        class_5250 component = class_2561.method_43471(langKey).method_27692(class_124.field_1080).method_27692(class_124.field_1056);
        class_2960 icon = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/entity/chat_bubble/yinyang_orb.png");
        return this.addChatBubble(WaitingChatBubbleData.create(30 * 20, TYPE_2, DEFAULT_PRIORITY, component, icon));
    }

    public void addLLMChatText(String message, long waitingChatBubbleId) {
        class_2561 component = class_2561.method_43470(message);
        TextChatBubbleData textChatBubble = TextChatBubbleData.type2(component);
        this.getChatBubbleDataCollection().remove(waitingChatBubbleId);
        this.getChatBubbleDataCollection().add(textChatBubble);
        this.forceUpdateChatBubble();

        // 给主人发送聊天栏信息
        if (maid.method_35057() instanceof class_3222 player) {
            class_2561 name = maid.method_5477();
            class_5250 msg = class_2561.method_43470("<").method_10852(name).method_27693(">").method_10852(class_5244.field_41874).method_27693(message);
            player.method_43496(msg.method_27692(class_124.field_1080));
        }
    }
}