package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.implement.EmojiChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class EmojiChatBubbleData implements IChatBubbleData {
    public static final class_2960 ID = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "emoji");
    private final class_2960 bg;
    @Environment(EnvType.CLIENT)
    private IChatBubbleRenderer renderer;

    public EmojiChatBubbleData(class_2960 bg) {
        this.bg = bg;
    }

    public static EmojiChatBubbleData create() {
        return new EmojiChatBubbleData(TYPE_2);
    }

    @Override
    public int existTick() {
        return DEFAULT_EXIST_TICK;
    }

    @Override
    public class_2960 id() {
        return ID;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public IChatBubbleRenderer getRenderer(IChatBubbleRenderer.Position position) {
        if (this.renderer == null) {
            this.renderer = new EmojiChatBubbleRenderer(this.bg);
        }
        return this.renderer;
    }

    public static class EmojiChatSerializer implements IChatBubbleData.ChatSerializer {
        @Override
        public IChatBubbleData readFromBuff(class_2540 buf) {
            class_2960 bg = buf.method_10810();
            return new EmojiChatBubbleData(bg);
        }

        @Override
        public void writeToBuff(class_2540 buf, IChatBubbleData data) {
            EmojiChatBubbleData emojiChat = (EmojiChatBubbleData) data;
            buf.method_10812(emojiChat.bg);
        }
    }
}
