package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import static com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid.*;

import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2945;
import net.minecraft.class_3532;

public class MaidConfigManager {
    private static final String PICKUP_TAG = "MaidIsPickup";
    private static final String HOME_TAG = "MaidIsHome";
    private static final String RIDEABLE_TAG = "MaidIsRideable";

    private static final String MAID_SUB_CONFIG_TAG = "MaidSubConfig";
    private static final String BACKPACK_SHOW_TAG = "BackpackShow";
    private static final String BACK_ITEM_SHOW_TAG = "BackItemShow";
    private static final String CHATBUBBLE_SHOW_TAG = "ChatBubbleShow";
    private static final String SOUND_FREQ_TAG = "SoundFreq";
    private static final String PICKUP_TYPE_TAG = "PickupType";
    private static final String OPEN_DOOR_TAG = "OpenDoor";
    private static final String OPEN_FENCE_GATE_TAG = "OpenFenceGate";
    private static final String ACTIVE_CLIMBING_TAG = "ActiveClimbing";

    private final class_2945 entityData;

    MaidConfigManager(class_2945 entityData) {
        this.entityData = entityData;
    }

    void defineSynchedData(class_2945.class_9222 builder) {
        builder.method_56912(DATA_PICKUP, true);
        builder.method_56912(DATA_HOME_MODE, false);
        builder.method_56912(DATA_RIDEABLE, true);

        builder.method_56912(BACKPACK_SHOW, true);
        builder.method_56912(BACK_ITEM_SHOW, true);
        builder.method_56912(CHATBUBBLE_SHOW, true);
        builder.method_56912(SOUND_FREQ, 1.0f);
        builder.method_56912(PICKUP_TYPE, PickType.ALL.ordinal());
        builder.method_56912(OPEN_DOOR, true);
        builder.method_56912(OPEN_FENCE_GATE, true);
        builder.method_56912(ACTIVE_CLIMBING, true);
    }

    void addAdditionalSaveData(class_2487 compound) {
        compound.method_10556(PICKUP_TAG, isPickup());
        compound.method_10556(HOME_TAG, isHomeModeEnable());
        compound.method_10556(RIDEABLE_TAG, isRideable());

        class_2487 maidSubConfig = new class_2487();
        maidSubConfig.method_10556(BACKPACK_SHOW_TAG, isShowBackpack());
        maidSubConfig.method_10556(BACK_ITEM_SHOW_TAG, isShowBackItem());
        maidSubConfig.method_10556(CHATBUBBLE_SHOW_TAG, isChatBubbleShow());
        maidSubConfig.method_10548(SOUND_FREQ_TAG, getSoundFreq());
        maidSubConfig.method_10569(PICKUP_TYPE_TAG, getPickupType().ordinal());
        maidSubConfig.method_10556(OPEN_DOOR_TAG, isOpenDoor());
        maidSubConfig.method_10556(OPEN_FENCE_GATE_TAG, isOpenFenceGate());
        maidSubConfig.method_10556(ACTIVE_CLIMBING_TAG, isActiveClimbing());
        compound.method_10566(MAID_SUB_CONFIG_TAG, maidSubConfig);
    }

    void readAdditionalSaveData(class_2487 compound) {
        if (compound.method_10573(PICKUP_TAG, class_2520.field_33251)) {
            setPickup(compound.method_10577(PICKUP_TAG));
        }
        if (compound.method_10573(HOME_TAG, class_2520.field_33251)) {
            setHomeModeEnable(compound.method_10577(HOME_TAG));
        }
        if (compound.method_10573(RIDEABLE_TAG, class_2520.field_33251)) {
            setRideable(compound.method_10577(RIDEABLE_TAG));
        }
        if (compound.method_10573(MAID_SUB_CONFIG_TAG, class_2520.field_33260)) {
            class_2487 maidSubConfig = compound.method_10562(MAID_SUB_CONFIG_TAG);
            if (maidSubConfig.method_10545(BACKPACK_SHOW_TAG)) {
                setShowBackpack(maidSubConfig.method_10577(BACKPACK_SHOW_TAG));
            }
            if (maidSubConfig.method_10545(BACK_ITEM_SHOW_TAG)) {
                setShowBackItem(maidSubConfig.method_10577(BACK_ITEM_SHOW_TAG));
            }
            if (maidSubConfig.method_10545(CHATBUBBLE_SHOW_TAG)) {
                setChatBubbleShow(maidSubConfig.method_10577(CHATBUBBLE_SHOW_TAG));
            }
            if (maidSubConfig.method_10545(SOUND_FREQ_TAG)) {
                setSoundFreq(maidSubConfig.method_10583(SOUND_FREQ_TAG));
            }
            if (maidSubConfig.method_10545(PICKUP_TYPE_TAG)) {
                setPickupType(PickType.values()[maidSubConfig.method_10550(PICKUP_TYPE_TAG)]);
            }
            if (maidSubConfig.method_10545(OPEN_DOOR_TAG)) {
                setOpenDoor(maidSubConfig.method_10577(OPEN_DOOR_TAG));
            }
            if (maidSubConfig.method_10545(OPEN_FENCE_GATE_TAG)) {
                setOpenFenceGate(maidSubConfig.method_10577(OPEN_FENCE_GATE_TAG));
            }
            if (maidSubConfig.method_10545(ACTIVE_CLIMBING_TAG)) {
                setActiveClimbing(maidSubConfig.method_10577(ACTIVE_CLIMBING_TAG));
            }
        }
    }

    boolean isHomeModeEnable() {
        return this.entityData.method_12789(DATA_HOME_MODE);
    }

    void setHomeModeEnable(boolean enable) {
        this.entityData.method_12778(DATA_HOME_MODE, enable);
    }

    boolean isPickup() {
        return this.entityData.method_12789(DATA_PICKUP);
    }

    void setPickup(boolean isPickup) {
        this.entityData.method_12778(DATA_PICKUP, isPickup);
    }

    boolean isRideable() {
        return this.entityData.method_12789(DATA_RIDEABLE);
    }

    void setRideable(boolean rideable) {
        this.entityData.method_12778(DATA_RIDEABLE, rideable);
    }

    public SyncNetwork getSyncNetwork() {
        return new SyncNetwork(
                this.isShowBackpack(),
                this.isShowBackItem(),
                this.isChatBubbleShow(),
                this.getSoundFreq(),
                this.getPickupType(),
                this.isOpenDoor(),
                this.isOpenFenceGate(),
                this.isActiveClimbing()
        );
    }

    public boolean isShowBackpack() {
        return this.entityData.method_12789(BACKPACK_SHOW);
    }

    public void setShowBackpack(boolean show) {
        this.entityData.method_12778(BACKPACK_SHOW, show);
    }

    public boolean isShowBackItem() {
        return this.entityData.method_12789(BACK_ITEM_SHOW);
    }

    public void setShowBackItem(boolean show) {
        this.entityData.method_12778(BACK_ITEM_SHOW, show);
    }

    public boolean isChatBubbleShow() {
        return this.entityData.method_12789(CHATBUBBLE_SHOW);
    }

    public void setChatBubbleShow(boolean show) {
        this.entityData.method_12778(CHATBUBBLE_SHOW, show);
    }

    public float getSoundFreq() {
        return this.entityData.method_12789(SOUND_FREQ);
    }

    public void setSoundFreq(float freq) {
        this.entityData.method_12778(SOUND_FREQ, class_3532.method_15363(freq, 0f, 1f));
    }

    public PickType getPickupType() {
        int index = this.entityData.method_12789(PICKUP_TYPE);
        return PickType.values()[index];
    }

    public void setPickupType(PickType type) {
        this.entityData.method_12778(PICKUP_TYPE, type.ordinal());
    }

    public boolean isOpenDoor() {
        return this.entityData.method_12789(OPEN_DOOR);
    }

    public void setOpenDoor(boolean openDoor) {
        this.entityData.method_12778(OPEN_DOOR, openDoor);
    }

    public boolean isOpenFenceGate() {
        return this.entityData.method_12789(OPEN_FENCE_GATE);
    }

    public void setOpenFenceGate(boolean openFenceGate) {
        this.entityData.method_12778(OPEN_FENCE_GATE, openFenceGate);
    }

    public boolean isActiveClimbing() {
        return this.entityData.method_12789(ACTIVE_CLIMBING);
    }

    public void setActiveClimbing(boolean activeClimbing) {
        this.entityData.method_12778(ACTIVE_CLIMBING, activeClimbing);
    }

    public static final class SyncNetwork {
        private boolean showBackpack;
        private boolean showBackItem;
        private boolean showChatBubble;
        private float soundFreq;
        private PickType pickType;
        private boolean openDoor;
        private boolean openFenceGate;
        private boolean activeClimbing;

        public SyncNetwork(boolean showBackpack, boolean showBackItem, boolean showChatBubble, float soundFreq,
                           PickType pickType, boolean openDoor, boolean openFenceGate, boolean activeClimbing) {
            this.showBackpack = showBackpack;
            this.showBackItem = showBackItem;
            this.showChatBubble = showChatBubble;
            this.soundFreq = soundFreq;
            this.pickType = pickType;
            this.openDoor = openDoor;
            this.openFenceGate = openFenceGate;
            this.activeClimbing = activeClimbing;
        }

        public static void encode(SyncNetwork message, class_2540 buf) {
            buf.method_52964(message.showBackpack);
            buf.method_52964(message.showBackItem);
            buf.method_52964(message.showChatBubble);
            buf.method_52941(message.soundFreq);
            buf.method_10817(message.pickType);
            buf.method_52964(message.openDoor);
            buf.method_52964(message.openFenceGate);
            buf.method_52964(message.activeClimbing);
        }

        public static SyncNetwork decode(class_2540 buf) {
            boolean showBackpack = buf.readBoolean();
            boolean showBackItem = buf.readBoolean();
            boolean showChatBubble = buf.readBoolean();
            float soundFreq = buf.readFloat();
            PickType pickType = buf.method_10818(PickType.class);
            boolean openDoor = buf.readBoolean();
            boolean openFenceGate = buf.readBoolean();
            boolean activeClimbing = buf.readBoolean();
            return new SyncNetwork(showBackpack, showBackItem, showChatBubble, soundFreq, pickType, openDoor, openFenceGate, activeClimbing);
        }

        public static void handle(SyncNetwork message, EntityMaid maid) {
            MaidConfigManager configManager = maid.getConfigManager();
            configManager.setShowBackpack(message.showBackpack);
            configManager.setShowBackItem(message.showBackItem);
            configManager.setChatBubbleShow(message.showChatBubble);
            configManager.setSoundFreq(message.soundFreq);
            configManager.setPickupType(message.pickType);
            configManager.setOpenDoor(message.openDoor);
            configManager.setOpenFenceGate(message.openFenceGate);
            configManager.setActiveClimbing(message.activeClimbing);
        }

        public boolean showBackpack() {
            return showBackpack;
        }

        public boolean showBackItem() {
            return showBackItem;
        }

        public boolean showChatBubble() {
            return showChatBubble;
        }

        public float soundFreq() {
            return soundFreq;
        }

        public PickType pickType() {
            return pickType;
        }

        public boolean openDoor() {
            return openDoor;
        }

        public boolean openFenceGate() {
            return openFenceGate;
        }

        public boolean activeClimbing() {
            return activeClimbing;
        }

        public void setShowBackpack(boolean showBackpack) {
            this.showBackpack = showBackpack;
        }

        public void setShowBackItem(boolean showBackItem) {
            this.showBackItem = showBackItem;
        }

        public void setShowChatBubble(boolean showChatBubble) {
            this.showChatBubble = showChatBubble;
        }

        public void setSoundFreq(float soundFreq) {
            this.soundFreq = class_3532.method_15363(soundFreq, 0f, 1f);
        }

        public void setPickType(PickType pickType) {
            this.pickType = pickType;
        }

        public void setOpenDoor(boolean openDoor) {
            this.openDoor = openDoor;
        }

        public void setOpenFenceGate(boolean openFenceGate) {
            this.openFenceGate = openFenceGate;
        }

        public void setActiveClimbing(boolean activeClimbing) {
            this.activeClimbing = activeClimbing;
        }
    }
}
