package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.api.mixin.INavigationMixin;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.MaidPathNavigation;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.MaidUnderWaterPathNavigation;
import net.minecraft.class_10;
import net.minecraft.class_11;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_4140;
import net.minecraft.class_5766;
import org.jetbrains.annotations.Nullable;

public class MaidNavigationManager {
    private final MaidPathNavigation basicNavigation;
    private final class_5766 waterNavigation;
    private final EntityMaid maid;
    private final class_1937 level;
    private Mode mode = Mode.GROUND;

    public MaidNavigationManager(EntityMaid maid) {
        this.maid = maid;
        this.level = maid.field_6002;
        this.basicNavigation = new MaidPathNavigation(maid, maid.field_6002);
        this.waterNavigation = new MaidUnderWaterPathNavigation(maid, maid.field_6002);
        maid.setNavigation(basicNavigation);
    }

    public void tick() {
        if (!level.field_9236 && maid.method_6034()) {
            if (mode != Mode.WATER && maid.method_5799() && shouldStartOrStopSwim(5)) {
                // 对于一般寻路，当满足：女仆接触到水，前方有长水面时，切换到水中寻路
                if (switchToNavigation(Mode.WATER, waterNavigation)) {
                    maid.getSwimManager().setWantToSwim(true);
                    maid.getSwimManager().setReadyToLand(false);
                }
            } else if (mode != Mode.WATER && maid.method_5869() && mayBeStuckUnderWater(maid.method_24515())) {
                // 如果女仆发现其所在位置不能上浮，那么也应该进入游泳状态（顶着头呆呆的）
                if (switchToNavigation(Mode.WATER, waterNavigation)) {
                    maid.getSwimManager().setWantToSwim(true);
                    maid.getSwimManager().setReadyToLand(false);
                }
            } else if (mode != Mode.WATER && maid.method_5799() && targetingUnderWater()) {
                // 如果目标在水下，那么女仆显然也应该进行水下寻路
                if (switchToNavigation(Mode.WATER, waterNavigation)) {
                    maid.getSwimManager().setWantToSwim(true);
                    maid.getSwimManager().setReadyToLand(false);
                }
            } else if (mode == Mode.WATER) {
                // 女仆当前正在使用水下寻路（不保证游泳的状态）
                // 如果满足使用水下寻路的附加条件，则不进行下面的判断（目标水下或者无法上浮），防止状态之间的闪烁
                boolean shouldUseWater = (maid.method_5799() && targetingUnderWater())
                        || (maid.method_5869() && mayBeStuckUnderWater(maid.method_24515()));
                // 要判断出水，需要当前存在路径
                class_2338 endPos = getEndPos(waterNavigation);
                if (!shouldUseWater && endPos != null) {
                    if (!shouldStartOrStopSwim(2)) {
                        // 即将走到水中寻路的尽头，你的女仆是否还需要游泳呢？
                        if (!level.method_22351(endPos) && !level.method_22351(endPos.method_10074())) {
                            // a：如果最终女仆是要上岸的，那么这时就没必要继续游泳了。立刻停止并切换到常规模式
                            if (switchToNavigation(Mode.GROUND, basicNavigation)) {
                                maid.getSwimManager().setReadyToLand(true);
                                maid.getSwimManager().setWantToSwim(false);
                            }
                        } else if (isWaterSurface(endPos)) {
                            // b：女仆最终来到了水面上
                            maid.getSwimManager().setWantToSwim(false);
                            maid.getSwimManager().setReadyToLand(false);
                        } else {
                            // c：仅仅是走到头了（
                            maid.getSwimManager().setWantToSwim(true);
                            maid.getSwimManager().setReadyToLand(false);
                        }
                    } else if (!maid.method_5799()) {
                        // b：女仆上岸了，立刻切换到常规寻路
                        if (switchToNavigation(Mode.GROUND, basicNavigation)) {
                            maid.getSwimManager().setWantToSwim(false);
                            maid.getSwimManager().setReadyToLand(false);
                        }
                    } else if (!maid.method_5869()) {
                        // 女仆半身入水（那貌似游泳就不大礼貌了）
                        maid.getSwimManager().setWantToSwim(false);
                    } else {
                        maid.getSwimManager().setWantToSwim(true);
                        maid.getSwimManager().setSwimTarget(endPos);
                    }
                } else if (endPos == null && maid.getSwimManager().isGoingToBreath()) {
                    // 有一种走完路径的特殊情况：女仆是想要去呼吸的。此时依然走的是水中寻路，但是应该取消游泳状态
                    maid.getSwimManager().setWantToSwim(false);
                } else if (shouldUseWater) {
                    // 当前满足游泳的条件（见上）
                    maid.getSwimManager().setWantToSwim(true);
                    // 没有走完路径，更新终点
                    if (endPos != null) {
                        maid.getSwimManager().setSwimTarget(endPos);
                    }
                }

            }
        }
        // 其他情况，如女仆进行一次传送，可能导致寻路中断，因此需要重新设置女仆是否要游泳
        if (mode != Mode.WATER) {
            maid.getSwimManager().setWantToSwim(false);
        }
    }

    private boolean targetingUnderWater() {
        // 判断 Target 是否在水下
        if (!maid.method_18868().method_18896(class_4140.field_18445)) {
            return false;
        }
        return isUnderWater(maid
                .method_18868()
                .method_18904(class_4140.field_18445)
                .get()
                .method_19094()
                .method_18989()
        );
    }


    @SuppressWarnings("all")
    private boolean switchToNavigation(Mode mode, class_1408 navigation) {
        class_1408 currentNavigation = maid.method_5942();
        if (!currentNavigation.method_6357()) {
            class_11 path = navigation.method_6348(currentNavigation.method_6345().method_45().method_22879(), 0);
            if (path != null && path.method_21655()) {
                if (navigation.method_6334(path, ((INavigationMixin) currentNavigation).touhouLittleMaid$GetSpeedModifier())) {
                    // 删除第一个寻路节点，有助于路径切换更加平滑（第一个巡路点的 center 可能会出现在身后）
                    path.method_44();
                    maid.setNavigation(navigation);
                    this.mode = mode;
                    currentNavigation.method_6340();
                    return true;
                }
            }
        } else {
            maid.setNavigation(navigation);
            navigation.method_6340();
            currentNavigation.method_6340();
            return true;
        }
        return false;
    }

    private boolean shouldStartOrStopSwim(int minimumDistance) {
        class_11 path = maid.method_5942().method_6345();
        if (path == null || path.method_46() || path.method_39() > path.method_38() - minimumDistance) {
            return false;
        }
        for (int i = path.method_39(), c = 0; c < minimumDistance; c++, i++) {
            if (!level.method_22351(path.method_40(i).method_22879())) {
                return false;
            }
        }
        return true;
    }

    /**
     * 判断女仆是否可能被卡在水下（头顶方块）
     * 即判断在水中的女仆头顶有没有方块
     */
    private boolean mayBeStuckUnderWater(class_2338 pos) {
        return level.method_22351(pos) && !level.method_8320(pos.method_10084()).method_26171(class_10.field_50);
    }

    public class_1408 getBasicNavigation() {
        return basicNavigation;
    }

    public class_1408 getWaterNavigation() {
        return waterNavigation;
    }

    public boolean isWaterSurface(class_2338 pos) {
        // 向上两层（主人浮在水上的话 target 可能是 -1Y 的），向上一层（寻路规则）
        return (level.method_22351(pos) && level.method_8320(pos.method_10084()).method_26215())
                || (level.method_22351(pos.method_10074()) && level.method_8320(pos).method_26215())
                || (level.method_22351(pos.method_10084()) && level.method_8320(pos.method_10086(2)).method_26215());
    }

    /**
     * 判断目标位置是否两格或更深
     */
    private boolean isUnderWater(class_2338 blockPos) {
        return level.method_22351(blockPos)
                && level.method_22351(blockPos.method_10084())
                && level.method_22351(blockPos.method_10086(2));
    }

    @Nullable
    public class_2338 getEndPos(class_1408 navigation) {
        if (navigation.method_6345() == null) {
            return null;
        }
        if (navigation.method_6345().method_45() == null) {
            return null;
        }
        return navigation.method_6345().method_45().method_22879();
    }

    public void resetNavigation() {
        maid.setNavigation(basicNavigation);
        basicNavigation.method_6340();
        waterNavigation.method_6340();
        maid.getSwimManager().setWantToSwim(false);
        maid.getSwimManager().setReadyToLand(false);
        mode = Mode.GROUND;
    }

    public enum Mode {
        GROUND,
        WATER
    }
}
