package com.github.tartaricacid.touhoulittlemaid.entity.task.meal;

import com.github.tartaricacid.touhoulittlemaid.api.task.meal.IMaidMeal;
import com.github.tartaricacid.touhoulittlemaid.api.task.meal.MaidMealType;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.event.MaidMealRegConfigEvent;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticlePackage;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_4174;
import net.minecraft.class_9334;

public class DefaultMaidWorkMeal implements IMaidMeal {
    private static final int MAX_PROBABILITY = 100;

    @Override
    public boolean canMaidEat(EntityMaid maid, class_1799 stack, class_1268 hand) {
        return stack.method_57824(class_9334.field_50075) /*stack.getFoodProperties(null)*/ != null && !IMaidMeal.isBlockList(stack, MaidConfig.MAID_WORK_MEALS_BLOCK_LIST.get())
                && !IMaidMeal.isBlockList(stack, MaidMealRegConfigEvent.WORK_MEAL_REGEX);
    }

    @Override
    public void onMaidEat(EntityMaid maid, class_1799 stack, class_1268 hand) {
        //FoodProperties foodProperties = stack.getFoodProperties(maid);
        class_4174 foodProperties = stack.method_57824(class_9334.field_50075);
        if (foodProperties != null) {
            // 调用饰品
            maid.getMaidBauble().fireEvent((b, s) -> {
                b.onMaidEat(maid, s, stack, MaidMealType.WORK_MEAL);
                return false;
            });

            maid.method_6019(hand);
            int nutrition = foodProperties.comp_2491();
            float saturationModifier = foodProperties.comp_2492();
            float total = nutrition + nutrition * saturationModifier * 2;
            // 原版的熟牛肉之类的一般在 20 左右（除了迷之炖菜为 34.2）
            int point = maid.method_59922().method_43048(MAX_PROBABILITY) < total ? 0 : 1;
            maid.getFavorabilityManager().apply(Type.WORK_MEAL, point);
            if (point == 1) {
                NetworkHandler.sendToNearby(maid, new SpawnParticlePackage(maid.method_5628(), SpawnParticlePackage.Type.HEART, stack.method_7935(maid)));
            }
        }
    }
}
