package com.github.tartaricacid.touhoulittlemaid.event.maid;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.api.event.InteractMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3417;

public final class GetExpBottleEvent {
    /**
     * WIKI 上说附魔之瓶会掉落 3-11 的经验 <br>
     * 那么我们就让其消耗 12 点经验获得一个附魔之瓶吧
     */
    private static final int PER_BOTTLE_XP = 12;


    public static void onInteract(InteractMaidEvent event) {
        class_1799 itemstack = event.getStack();
        class_1657 player = event.getPlayer();
        EntityMaid maid = event.getMaid();
        class_1937 world = event.getWorld();

        if (itemstack.method_7909() == class_1802.field_8469) {
            int count = maid.getExperience() / PER_BOTTLE_XP;
            if (count <= 0) {
                return;
            }
            if (player.method_21751()) {
                count = Math.min(count, itemstack.method_7947());
            } else {
                count = 1;
            }
            int costNum = PER_BOTTLE_XP * count;
            maid.setExperience(maid.getExperience() - costNum);
            itemstack.method_7934(count);
            if (!world.field_9236) {
                class_1799 xpBottles = new class_1799(class_1802.field_8287, count);
                class_1264.method_5449(world, player.method_23317(), player.method_23318(), player.method_23321(), xpBottles);
            }
            maid.method_5783(class_3417.field_15197, 0.2F, ((world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.7F + 1.0F) * 2.0F);
            if (player instanceof class_3222 serverPlayer) {
                InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.TAKE_MAID_XP);
            }
            event.setCanceled(true);
        }
    }
}
