package com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandler;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.SlotItemHandler;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.data.TankBackpackData;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import com.mojang.datafixers.util.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3913;
import net.minecraft.class_3917;
import net.minecraft.class_9135;

import static net.minecraft.class_1723.field_21668;

public class TankBackpackContainer extends MaidMainContainer {
    public static final class_3917<TankBackpackContainer> TYPE = new ExtendedScreenHandlerType<>(TankBackpackContainer::new, class_9135.field_49675);
    private static final class_2960 INPUT_SLOT = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "slot/tank_input_slot");
    private static final class_2960 OUTPUT_SLOT = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "slot/tank_output_slot");
    private final class_3913 data;
    private int clientFluidAmount;

    public TankBackpackContainer(int id, class_1661 inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
        TankBackpackData tankData;
        if (this.getMaid().getBackpackData() instanceof TankBackpackData) {
            tankData = (TankBackpackData) this.getMaid().getBackpackData();
        } else {
            tankData = new TankBackpackData(this.getMaid());
        }
        this.data = tankData.getDataAccess();
        this.method_7621(new TankInputSlot(tankData, 0, 161, 101));
        this.method_7621(new TankOutputSlot(tankData, 1, 161, 140));
        this.method_17360(this.data);
    }

    @Override
    protected void addBackpackInv(class_1661 inventory) {
        IItemHandler itemHandler = maid.getMaidInv();
        for (int i = 0; i < 6; i++) {
            method_7621(new SlotItemHandler(itemHandler, 6 + i, 143 + 18 * i, 57));
        }
        for (int i = 0; i < 6; i++) {
            method_7621(new SlotItemHandler(itemHandler, 12 + i, 143 + 18 * i, 75));
        }
    }

    public int getFluidCount() {
        return this.data.method_17390(0);
    }

    // 客户端同步
    public void setClientFluidCount(int amount) {
        this.clientFluidAmount = amount;
    }

    public int getClientFluidAmount() {
        return this.clientFluidAmount;
    }

    public static class TankInputSlot extends class_1735 {
        public TankInputSlot(class_1263 pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        @Override
        public boolean method_7680(class_1799 stack) {
            //return FluidUtil.getFluidHandler(stack).isPresent();
            return ContainerItemContext.withConstant(stack).find(FluidStorage.ITEM) != null;
        }

        @Override
        @Environment(EnvType.CLIENT)
        public Pair<class_2960, class_2960> method_7679() {
            return Pair.of(field_21668, INPUT_SLOT);
        }
    }

    public static class TankOutputSlot extends class_1735 {
        public TankOutputSlot(class_1263 pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        @Override
        public boolean method_7680(class_1799 stack) {
            //return FluidUtil.getFluidHandler(stack).isPresent();
            return ContainerItemContext.withConstant(stack).find(FluidStorage.ITEM) != null;
        }

        @Override
        @Environment(EnvType.CLIENT)
        public Pair<class_2960, class_2960> method_7679() {
            return Pair.of(field_21668, OUTPUT_SLOT);
        }
    }
}
