package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatSerializable;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record SaveMaidAIDataPackage(int entityId, MaidAIChatSerializable data) implements class_8710 {
    public static final class_8710.class_9154<SaveMaidAIDataPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("save_maid_ai_data"));
    public static final class_9139<ByteBuf, SaveMaidAIDataPackage> STREAM_CODEC = new class_9139<>() {
        @Override
        public SaveMaidAIDataPackage decode(ByteBuf byteBuf) {
            class_2540 buf = new class_2540(byteBuf);
            int entityId = buf.readInt();
            MaidAIChatSerializable data = new MaidAIChatSerializable();
            data.decode(buf);
            return new SaveMaidAIDataPackage(entityId, data);
        }

        @Override
        public void encode(ByteBuf byteBuf, SaveMaidAIDataPackage message) {
            class_2540 buf = new class_2540(byteBuf);
            buf.method_53002(message.entityId);
            message.data.encode(buf);
        }
    };

    @Override
    public @NotNull class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(SaveMaidAIDataPackage message, ServerPlayNetworking.Context context) {
        context.server().execute(() -> handle(message, context.player()));
    }

    private static void handle(SaveMaidAIDataPackage message, @Nullable class_3222 player) {
        if (player == null) {
            return;
        }
        class_1297 entity = player.field_6002.method_8469(message.entityId);
        if (entity instanceof EntityMaid maid && maid.method_6171(player)) {
            maid.getAiChatManager().copyFrom(message.data);
        }
    }
}
