package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.AvailableSites;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSSystemServices;
import io.netty.buffer.ByteBuf;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record TTSSystemAudioToClientPackage(String siteName, String chatText, TTSConfig config,
                                            TTSSystemServices services) implements class_8710 {
    public static final class_8710.class_9154<TTSSystemAudioToClientPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("tts_system_audio_to_client"));
    public static final class_9139<ByteBuf, TTSSystemAudioToClientPackage> STREAM_CODEC = new class_9139<>() {
        @Override
        public TTSSystemAudioToClientPackage decode(ByteBuf byteBuf) {
            class_2540 buf = new class_2540(byteBuf);
            String siteName = buf.method_19772();
            TTSSite ttsSite = AvailableSites.getTTSSite(siteName);
            if (ttsSite.client() instanceof TTSSystemServices services) {
                Pair<String, TTSConfig> pair = services.readFromNetwork(buf);
                return new TTSSystemAudioToClientPackage(siteName, pair.getLeft(), pair.getRight(), services);
            }
            throw new IllegalArgumentException("Invalid TTS site: " + siteName);
        }

        @Override
        public void encode(ByteBuf byteBuf, TTSSystemAudioToClientPackage message) {
            class_2540 buf = new class_2540(byteBuf);
            buf.method_10814(message.siteName);
            message.services.writeToNetwork(message.chatText, message.config, buf);
        }
    };

    public static void handle(TTSSystemAudioToClientPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> onHandle(message));
    }

    @Environment(EnvType.CLIENT)
    private static void onHandle(TTSSystemAudioToClientPackage message) {
        TTSSite ttsSite = AvailableSites.getTTSSite(message.siteName);
        if (ttsSite == null || !ttsSite.enabled()) {
            return;
        }
        ttsSite.client().play(message.chatText, message.config, null);
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
