package com.github.tartaricacid.touhoulittlemaid.tileentity;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlockEntityPersistentData;
import com.github.tartaricacid.touhoulittlemaid.api.block.IBoardGameEntityBlock;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.GomokuCodec;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Statue;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

public class TileEntityGomoku extends TileEntityJoy implements IBoardGameEntityBlock, IBlockEntityPersistentData {
    public static final class_2591<TileEntityGomoku> TYPE = class_2591.class_2592.method_20528(TileEntityGomoku::new, InitBlocks.GOMOKU).method_11034(null);
    private static final String CHESS_DATA = "ChessData";
    private static final String STATUE = "Statue";
    private static final String PLAYER_TURN = "PlayerTurn";
    private static final String CHESS_COUNTER = "ChessCounter";
    private static final String LATEST_CHESS_POINT = "LatestChessPoint";

    private byte[][] chessData = new byte[15][15];
    private int statue = Statue.IN_PROGRESS.ordinal();
    private boolean playerTurn = true;
    private int chessCounter = 0;
    private Point latestChessPoint = Point.NULL;

    public TileEntityGomoku(class_2338 pos, class_2680 blockState) {
        super(TYPE, pos, blockState);
    }

    @Override
    protected void method_11007(class_2487 pTag, class_7225.class_7874 pRegistries) {
        class_2499 listTag = new class_2499();
        for (byte[] chessRow : chessData) {
            listTag.add(new class_2479(chessRow));
        }
        tlm$getPersistentData().method_10566(CHESS_DATA, listTag);
        tlm$getPersistentData().method_10569(STATUE, this.statue);
        tlm$getPersistentData().method_10556(PLAYER_TURN, this.playerTurn);
        tlm$getPersistentData().method_10569(CHESS_COUNTER, this.chessCounter);
        tlm$getPersistentData().method_10566(LATEST_CHESS_POINT, Point.toTag(this.latestChessPoint));
        super.method_11007(pTag, pRegistries);
    }

    @Override
    public void method_11014(class_2487 pTag, class_7225.class_7874 pRegistries) {
        super.method_11014(pTag, pRegistries);
        class_2499 listTag = tlm$getPersistentData().method_10554(CHESS_DATA, class_2520.field_33257);
        for (int i = 0; i < listTag.size(); i++) {
            class_2479 byteArray = (class_2479) listTag.method_10534(i);
            this.chessData[i] = byteArray.method_10521();
        }
        this.statue = tlm$getPersistentData().method_10550(STATUE);
        this.playerTurn = tlm$getPersistentData().method_10577(PLAYER_TURN);
        this.chessCounter = tlm$getPersistentData().method_10550(CHESS_COUNTER);
        this.latestChessPoint = Point.fromTag(tlm$getPersistentData().method_10562(LATEST_CHESS_POINT));
    }

    public void reset() {
        this.chessData = new byte[15][15];
        this.statue = Statue.IN_PROGRESS.ordinal();
        this.playerTurn = true;
        this.chessCounter = 0;
        this.latestChessPoint = Point.NULL;
    }

    public byte[][] getChessData() {
        return chessData;
    }

    public void setChessData(List<byte[]> arrayList) {
        for (int i = 0; i < arrayList.size(); i++) {
            this.chessData[i] = arrayList.get(i);
        }
    }

    public void setChessData(int x, int y, int type) {
        this.chessData[x][y] = (byte) type;
        this.latestChessPoint = new Point(x, y, type);
        this.chessCounter += 1;
    }

    // 调试功能，铺满棋盘，只剩三个位置
    public void clickWithDebug() {
        byte[][] drawBoard = new byte[15][15];
        for (int x = 0; x < 15; x++) {
            boolean blackFirst = (x / 2) % 2 == 0;
            for (int y = 0; y < 15; y++) {
                // 14,(12-14) 留空
                if (x == 14 && 12 <= y) {
                    drawBoard[x][y] = Point.EMPTY;
                    continue;
                }
                // 奇偶交替填充，避免出现五连
                if (blackFirst) {
                    drawBoard[x][y] = (y % 2 == 0) ? (byte) Point.BLACK : (byte) Point.WHITE;
                } else {
                    drawBoard[x][y] = (y % 2 == 0) ? (byte) Point.WHITE : (byte) Point.BLACK;
                }
            }
        }
        this.chessData = drawBoard;
        this.latestChessPoint = new Point(14, 10, Point.WHITE);
        this.chessCounter = 15 * 15 - 3;
        this.statue = Statue.IN_PROGRESS.ordinal();
        this.playerTurn = true;
    }

    public boolean isPlayerTurn() {
        return playerTurn;
    }

    public void setPlayerTurn(boolean playerTurn) {
        this.playerTurn = playerTurn;
    }

    public void setStatue(Statue statue) {
        this.statue = statue.ordinal();
    }

    public Statue getStatue() {
        return Statue.values()[class_3532.method_15340(statue, 0, Statue.values().length - 1)];
    }

    public int getChessCounter() {
        return chessCounter;
    }

    public Point getLatestChessPoint() {
        return latestChessPoint;
    }

    public GomokuCodec.StateData getStateData() {
        return new GomokuCodec.StateData(this.chessData, this.chessCounter, this.latestChessPoint);
    }

    public void setStateData(GomokuCodec.StateData stateData) {
        this.chessData = stateData.board();
        this.chessCounter = stateData.turnCount();
        this.latestChessPoint = stateData.latestPoint();
        this.refresh();
    }
}
