/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service;

import com.github.tartaricacid.touhoulittlemaid.ai.service.Client;
import com.github.tartaricacid.touhoulittlemaid.ai.service.SerializableSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.SerializerRegister;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ServiceType;
import com.google.common.annotations.Beta;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public interface Site {
    public static final String ID = "id";
    public static final String API_TYPE = "api_type";
    public static final String ENABLED = "enabled";
    public static final String ICON = "icon";
    public static final String URL = "url";
    public static final String SECRET_KEY = "secret_key";
    public static final String HEADERS = "headers";
    public static final String MODELS = "models";
    public static final ToIntFunction<String> FIXED_ORDER_FIELDS = (ToIntFunction)class_156.method_654((Object)new Object2IntOpenHashMap(), map -> {
        map.put((Object)ID, 0);
        map.put((Object)API_TYPE, 1);
        map.put((Object)ENABLED, 2);
        map.put((Object)ICON, 3);
        map.put((Object)URL, 4);
        map.put((Object)SECRET_KEY, 5);
        map.put((Object)HEADERS, 6);
        map.defaultReturnValue(100);
        map.put((Object)MODELS, Integer.MAX_VALUE);
    });
    public static final Comparator<String> KEY_COMPARATOR = Comparator.comparingInt(FIXED_ORDER_FIELDS).thenComparing(Function.identity());

    public String id();

    public boolean enabled();

    public class_2960 icon();

    public String url();

    public Map<String, String> headers();

    public ServiceType getServiceType();

    public String getApiType();

    public Client client();

    default public SerializableSite<? extends Site> serializer() {
        return SerializerRegister.getSerializer(this.getServiceType(), this.getApiType());
    }

    @Beta
    default public class_2561 getName() {
        return class_2561.method_43471((String)"ai.touhou_little_maid.chat.site.%s.name".formatted(this.id()));
    }

    @Beta
    default public class_2561 getDesc() {
        return class_2561.method_43471((String)"ai.touhou_little_maid.chat.site.%s.desc".formatted(this.id()));
    }
}

