/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlock;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemHandlerHelper;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import com.github.tartaricacid.touhoulittlemaid.block.properties.PicnicMatPart;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemPicnicBasket;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityPicnicMat;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_702;
import net.minecraft.class_9062;
import net.minecraft.class_9334;

public class BlockPicnicMat
extends class_2248
implements class_2343,
IBlock {
    public static final class_2754<PicnicMatPart> PART = class_2754.method_11850((String)"part", PicnicMatPart.class);
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_265 AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public BlockPicnicMat() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9626(class_2498.field_11547).method_9629(2.0f, 3.0f).method_51369().method_22488());
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(PART, (Comparable)((Object)PicnicMatPart.CENTER)));
    }

    public void startMaidSit(EntityMaid maid, class_2680 state, class_1937 worldIn, class_2338 pos) {
        if (worldIn instanceof class_3218) {
            class_3218 serverLevel = (class_3218)worldIn;
            class_2586 class_25862 = worldIn.method_8321(pos);
            if (class_25862 instanceof TileEntityPicnicMat) {
                TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)class_25862;
                if (!((PicnicMatPart)((Object)state.method_11654(PART))).isCenter()) {
                    return;
                }
                boolean hasEmptySit = false;
                int sitIndex = -1;
                for (UUID uuid : picnicMat.getSitIds()) {
                    ++sitIndex;
                    if (uuid.equals(class_156.field_25140)) {
                        hasEmptySit = true;
                        break;
                    }
                    class_1297 oldSitEntity = serverLevel.method_14190(uuid);
                    if (oldSitEntity != null && oldSitEntity.method_5805()) continue;
                    hasEmptySit = true;
                    break;
                }
                if (hasEmptySit) {
                    class_243 sitPosition = this.sitPosition(sitIndex);
                    EntitySit newSitEntity = new EntitySit(worldIn, class_243.method_49273((class_2382)pos, (double)sitPosition.field_1352, (double)(sitPosition.field_1351 + 0.0625), (double)sitPosition.field_1350), Type.ON_HOME_MEAL.getTypeName(), pos);
                    double y = sitPosition.field_1350 < 0.0 ? -1.0 : 1.0;
                    double x = sitPosition.field_1352 < 0.0 ? -1.0 : 1.0;
                    double rotOffset = Math.toDegrees(Math.atan2(y, x));
                    newSitEntity.method_36456((float)rotOffset + 90.0f);
                    worldIn.method_8649((class_1297)newSitEntity);
                    picnicMat.setSitId(sitIndex, newSitEntity.method_5667());
                    maid.method_5804(newSitEntity);
                }
            }
        }
    }

    private class_243 sitPosition(int sitIndex) {
        switch (sitIndex) {
            case 0: {
                return new class_243(2.0, 0.0, 2.0);
            }
            case 1: {
                return new class_243(-1.0, 0.0, 2.0);
            }
            case 2: {
                return new class_243(-1.0, 0.0, -1.0);
            }
        }
        return new class_243(2.0, 0.0, -1.0);
    }

    public class_9062 method_55765(class_1799 itemStack, class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_1268 hand, class_3965 hit) {
        if (worldIn.field_9236) {
            return class_9062.field_47732;
        }
        if (hand != class_1268.field_5808) {
            return class_9062.field_47732;
        }
        class_2586 class_25862 = worldIn.method_8321(pos);
        if (!(class_25862 instanceof TileEntityPicnicMat)) {
            return class_9062.field_47733;
        }
        TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)class_25862;
        class_2338 centerPos = picnicMat.getCenterPos();
        class_2586 class_25863 = worldIn.method_8321(centerPos);
        if (!(class_25863 instanceof TileEntityPicnicMat)) {
            return class_9062.field_47733;
        }
        TileEntityPicnicMat picnicMatCenter = (TileEntityPicnicMat)class_25863;
        class_1799 itemInHand = playerIn.method_5998(hand);
        if (itemInHand.method_57824(class_9334.field_50075) != null) {
            return BlockPicnicMat.placeFood(itemInHand, playerIn, picnicMatCenter);
        }
        if (itemInHand.method_7960() && playerIn.method_21751()) {
            return BlockPicnicMat.takeFood(playerIn, picnicMatCenter);
        }
        return class_9062.field_47732;
    }

    private static class_9062 placeFood(class_1799 food, class_1657 playerIn, TileEntityPicnicMat picnicMatCenter) {
        int count = food.method_7947();
        class_1799 resultStack = ItemHandlerHelper.insertItemStacked(picnicMatCenter.getHandler(), food.method_7972(), false);
        picnicMatCenter.refresh();
        int shrinkCount = count - resultStack.method_7947();
        if (shrinkCount <= 0) {
            return class_9062.field_47733;
        }
        food.method_7934(shrinkCount);
        return class_9062.field_47728;
    }

    private static class_9062 takeFood(class_1657 playerIn, TileEntityPicnicMat picnicMatCenter) {
        int size;
        ItemStackHandler handler = picnicMatCenter.getHandler();
        for (int i = size = handler.getSlots() - 1; i >= 0; --i) {
            class_1799 stack = handler.getStackInSlot(i);
            if (stack.method_7960()) continue;
            class_1799 outputStack = handler.extractItem(i, handler.getSlotLimit(i), false);
            picnicMatCenter.refresh();
            ItemHandlerHelper.giveItemToPlayer(playerIn, outputStack);
            return class_9062.field_47728;
        }
        return class_9062.field_47733;
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        BlockPicnicMat.handlePicnicMatRemove(world, pos, state);
        return super.method_9576(world, pos, state, player);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean tlm$addHitEffects(class_2680 state, class_1937 world, class_239 target, class_702 manager) {
        return false;
    }

    @Override
    public void tlm$onBlockExploded(class_2680 state, class_1937 world, class_2338 pos, class_1927 explosion) {
        BlockPicnicMat.handlePicnicMatRemove(world, pos, state);
        IBlock.super.tlm$onBlockExploded(state, world, pos, explosion);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2338 centerPos = context.method_8037();
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                class_2338 searchPos = centerPos.method_10069(i, 0, j);
                if (context.method_8045().method_8320(searchPos).method_26166(context)) continue;
                return null;
            }
        }
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
    }

    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(worldIn, pos, state, placer, stack);
        if (worldIn.field_9236) {
            return;
        }
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                class_2586 blockEntity;
                class_2338 searchPos = pos.method_10069(i, 0, j);
                if (!searchPos.equals((Object)pos)) {
                    worldIn.method_8652(searchPos, (class_2680)state.method_11657(PART, (Comparable)((Object)PicnicMatPart.SIDE)), 3);
                }
                if (!((blockEntity = worldIn.method_8321(searchPos)) instanceof TileEntityPicnicMat)) continue;
                TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)blockEntity;
                picnicMat.setCenterPos(pos);
            }
        }
        class_2586 blockEntity = worldIn.method_8321(pos);
        if (blockEntity instanceof TileEntityPicnicMat) {
            TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)blockEntity;
            if (stack.method_31574(InitItems.PICNIC_BASKET)) {
                picnicMat.setHandler(ItemPicnicBasket.getContainer(stack));
            }
        }
    }

    public boolean method_9558(class_2680 blockState, class_4538 level, class_2338 blockPos) {
        class_2338 below = blockPos.method_10074();
        return level.method_8320(below).method_26206((class_1922)level, below, class_2350.field_11036);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, PART});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TileEntityPicnicMat(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public boolean method_9516(class_2680 state, class_10 type) {
        return true;
    }

    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return AABB;
    }

    private static void handlePicnicMatRemove(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.field_9236) {
            return;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof TileEntityPicnicMat)) {
            return;
        }
        TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)class_25862;
        class_2338 centerPos = picnicMat.getCenterPos();
        class_2586 class_25863 = world.method_8321(centerPos);
        if (class_25863 instanceof TileEntityPicnicMat) {
            TileEntityPicnicMat picnicMatCenter = (TileEntityPicnicMat)class_25863;
            class_1799 stack = InitItems.PICNIC_BASKET.method_7854();
            ItemPicnicBasket.setContainer(stack, picnicMatCenter.getHandler());
            BlockPicnicMat.method_9577((class_1937)world, (class_2338)centerPos, (class_1799)stack);
            if (world instanceof class_3218) {
                class_3218 serverLevel = (class_3218)world;
                for (UUID uuid : picnicMatCenter.getSitIds()) {
                    class_1297 entity;
                    if (uuid.equals(class_156.field_25140) || !((entity = serverLevel.method_14190(uuid)) instanceof EntitySit)) continue;
                    entity.method_31472();
                }
            }
        }
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                class_2338 offset = centerPos.method_10069(i, 0, j);
                if (!world.method_8320(offset).method_27852(InitBlocks.PICNIC_MAT)) continue;
                world.method_8501(offset, class_2246.field_10124.method_9564());
            }
        }
    }
}

