/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationManager;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationState;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.ILoopType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import java.util.function.BiPredicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1690;
import net.minecraft.class_4050;

public class AnimationRegister {
    private static final double MIN_SPEED = 0.05;

    public static void registerAnimationState() {
        AnimationRegister.register("death", ILoopType.EDefaultLoopTypes.PLAY_ONCE, 0, (maid, event) -> maid.asEntity().method_29504());
        AnimationRegister.register("sleep", 0, (maid, event) -> maid.asEntity().method_18376() == class_4050.field_18078);
        AnimationRegister.register("swim", 0, (maid, event) -> maid.asEntity().method_20232());
        AnimationRegister.register("ladder_up", 0, (maid, event) -> maid.method_6101() && AnimationRegister.getVerticalSpeed(maid) > 0.0f);
        AnimationRegister.register("ladder_stillness", 0, (maid, event) -> maid.method_6101() && AnimationRegister.getVerticalSpeed(maid) == 0.0f);
        AnimationRegister.register("ladder_down", 0, (maid, event) -> maid.method_6101() && AnimationRegister.getVerticalSpeed(maid) < 0.0f);
        AnimationRegister.register("gomoku", 1, (maid, event) -> AnimationRegister.sitInJoy(maid, Type.GOMOKU));
        AnimationRegister.register("bookshelf", 1, (maid, event) -> AnimationRegister.sitInJoy(maid, Type.BOOKSHELF));
        AnimationRegister.register("computer", 1, (maid, event) -> AnimationRegister.sitInJoy(maid, Type.COMPUTER));
        AnimationRegister.register("keyboard", 1, (maid, event) -> AnimationRegister.sitInJoy(maid, Type.KEYBOARD));
        AnimationRegister.register("picnic", 1, (maid, event) -> AnimationRegister.sitInJoy(maid, Type.ON_HOME_MEAL));
        AnimationRegister.register("boat", 1, (maid, event) -> maid.asEntity().method_5854() instanceof class_1690);
        AnimationRegister.register("chair", 1, (maid, event) -> maid.asEntity().method_5765());
        AnimationRegister.register("sit", 1, (maid, event) -> maid.isMaidInSittingPose());
        AnimationRegister.register("swim_stand", 2, (maid, event) -> maid.asEntity().method_5799());
        AnimationRegister.register("attacked", ILoopType.EDefaultLoopTypes.PLAY_ONCE, 2, (maid, event) -> maid.asEntity().field_6235 > 0);
        AnimationRegister.register("jump", 2, (maid, event) -> !maid.asEntity().method_24828() && !maid.asEntity().method_5799());
        AnimationRegister.register("run", 3, (maid, event) -> maid.asEntity().method_24828() && maid.asEntity().method_5624());
        AnimationRegister.register("walk", 3, (maid, event) -> maid.asEntity().method_24828() && (double)event.getLimbSwingAmount() > 0.05);
        AnimationRegister.register("idle", 4, (maid, event) -> true);
    }

    private static boolean sitInJoy(IMaid maid, Type type) {
        EntitySit sit;
        class_1297 class_12972 = maid.asEntity().method_5854();
        return class_12972 instanceof EntitySit && (sit = (EntitySit)class_12972).getJoyType().equals(type.getTypeName());
    }

    private static void register(String animationName, ILoopType loopType, int priority, BiPredicate<IMaid, AnimationEvent<?>> predicate) {
        AnimationManager manager = AnimationManager.getInstance();
        manager.register(new AnimationState(animationName, loopType, priority, predicate));
    }

    private static void register(String animationName, int priority, BiPredicate<IMaid, AnimationEvent<?>> predicate) {
        AnimationRegister.register(animationName, ILoopType.EDefaultLoopTypes.LOOP, priority, predicate);
    }

    private static float getVerticalSpeed(IMaid maid) {
        class_1308 entity = maid.asEntity();
        return 20.0f * (float)(entity.method_19538().field_1351 - entity.field_6036);
    }
}

