/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatManager;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.CharacterSetting;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.SettingReader;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.bean.MetaData;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SaveMaidAIDataPackage;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_7529;
import net.minecraft.class_8710;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class SettingEditScreen
extends class_437 {
    private static final long MAX_TIP_TIME = 2000L;
    private final EntityMaid maid;
    private final MaidAIChatManager manager;
    private class_342 ownerName;
    private class_7529 customSetting;
    private long tipTimestamp = -1L;

    public SettingEditScreen(EntityMaid maid) {
        super((class_2561)class_2561.method_43470((String)"Setting Edit Screen"));
        this.maid = maid;
        this.manager = maid.getAiChatManager();
    }

    protected void method_25426() {
        this.method_37067();
        int posX = this.field_22789 / 2 - 195;
        int boxWidth = 256;
        this.ownerName = (class_342)this.method_37063((class_364)new class_342(this.field_22793, posX + 1, 30, boxWidth - 2, 20, (class_2561)class_2561.method_43470((String)"Owner Name Box")));
        this.ownerName.method_1852(this.manager.ownerName);
        this.ownerName.method_1880(128);
        this.ownerName.method_1863(s -> {
            this.manager.ownerName = s;
        });
        this.customSetting = (class_7529)this.method_37063((class_364)new class_7529(this.field_22793, posX, 70, boxWidth, this.field_22790 - 100, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.edit"), (class_2561)class_2561.method_43470((String)"Custom Setting Box")));
        this.customSetting.method_44400(this.manager.customSetting);
        this.customSetting.method_44402(4096);
        this.customSetting.method_44401(s -> {
            this.manager.customSetting = s;
        });
        class_5250 export = class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.export");
        this.method_37063((class_364)class_4185.method_46430((class_2561)export, b -> this.exportSetting(export)).method_46434(posX + 265, this.ownerName.method_46427(), 128, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"selectWorld.edit.save"), b -> {
            this.saveConfig();
            this.tipTimestamp = System.currentTimeMillis();
        }).method_46434(posX + 265, this.customSetting.method_46427(), 128, 20).method_46431());
        class_5250 saveQuit = class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.save_and_quit");
        this.method_37063((class_364)class_4185.method_46430((class_2561)saveQuit, b -> {
            this.saveConfig();
            class_310.method_1551().method_1507(null);
        }).method_46434(posX + 265, this.customSetting.method_46427() + 25, 128, 20).method_46431());
    }

    private void exportSetting(class_5250 export) {
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            String title = export.getString();
            String defaultFileName = "%s.yml".formatted(this.maid.method_5477().getString());
            String path = SettingReader.getSettingsFolder().resolve(defaultFileName).toString();
            String fileFilter = class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.export.format").getString();
            PointerBuffer filterPattern = memoryStack.mallocPointer(1);
            filterPattern.put(memoryStack.UTF8((CharSequence)"*.yml"));
            filterPattern.flip();
            String result = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)title, (CharSequence)path, (PointerBuffer)filterPattern, (CharSequence)fileFilter);
            if (StringUtils.isBlank((CharSequence)result)) {
                return;
            }
            File exportFile = new File(result);
            MetaData metaData = this.getMetaData();
            CharacterSetting setting = new CharacterSetting(metaData, this.customSetting.method_44405());
            setting.save(exportFile);
            if (Screens.getClient((class_437)this).field_1724 != null) {
                class_5250 tip = class_2561.method_43469((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.export.success", (Object[])new Object[]{result}).method_27692(class_124.field_1080);
                Screens.getClient((class_437)this).field_1724.method_43496((class_2561)tip);
            }
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Error saving setting", (Throwable)e);
        }
    }

    @NotNull
    private MetaData getMetaData() {
        String lang = Screens.getClient((class_437)this).method_1526().method_4669();
        String author = "Unknown";
        if (Screens.getClient((class_437)this).field_1724 != null) {
            author = Screens.getClient((class_437)this).field_1724.method_5820();
        }
        String modelId = this.maid.getModelId();
        return new MetaData(0, author, Collections.singletonList(modelId), lang);
    }

    public void method_25410(class_310 mc, int pWidth, int pHeight) {
        String ownerNameValue = this.ownerName.method_1882();
        String customSettingValue = this.customSetting.method_44405();
        super.method_25410(mc, pWidth, pHeight);
        this.ownerName.method_1852(ownerNameValue);
        this.customSetting.method_44400(customSettingValue);
    }

    public boolean method_25406(double x, double y, int button) {
        return super.method_25406(x, y, button) || this.customSetting.method_25406(x, y, button);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.owner_name"), this.ownerName.method_46426() + 2, this.ownerName.method_46427() - 12, 0xFFFFFF);
        graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.custom_setting"), this.customSetting.method_46426() + 2, this.customSetting.method_46427() - 12, 0xFFFFFF);
        this.drawMaid(graphics, this.customSetting.method_46426() + this.customSetting.method_25368() + 73, this.customSetting.method_46427() + 96, this.maid);
        long time = System.currentTimeMillis() - this.tipTimestamp;
        if (time < 2000L) {
            double value = (double)time / 2000.0 * Math.PI;
            int alpha = (int)(Math.sin(value) * 255.0);
            alpha = class_3532.method_15340((int)alpha, (int)15, (int)240);
            graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.saved"), this.customSetting.method_46426() + this.customSetting.method_25368() + 73, this.customSetting.method_46427() - 12, (alpha << 24) + 0xFF1111);
        }
    }

    private void drawMaid(class_332 graphics, int posX, int posY, EntityMaid rawMaid) {
        EntityMaid maid;
        class_638 world = Screens.getClient((class_437)this).field_1687;
        if (world == null) {
            return;
        }
        Optional<MaidModelInfo> info = CustomPackLoader.MAID_MODELS.getInfo(rawMaid.getModelId());
        if (info.isEmpty()) {
            return;
        }
        MaidModelInfo modelInfo = info.get();
        try {
            maid = (EntityMaid)EntityCacheUtil.ENTITY_CACHE.get(EntityMaid.TYPE, () -> SettingEditScreen.lambda$drawMaid$6((class_1937)world));
        }
        catch (ClassCastException | ExecutionException e) {
            e.fillInStackTrace();
            return;
        }
        EntityCacheUtil.clearMaidDataResidue(maid, false);
        if (modelInfo.getEasterEgg() != null) {
            maid.setModelId("touhou_little_maid:easter_egg_model");
        } else {
            maid.setModelId(modelInfo.getModelId().toString());
        }
        maid.setIsYsmModel(false);
        float renderItemScale = modelInfo.getRenderItemScale();
        class_490.method_2486((class_332)graphics, (int)(posX - 45), (int)(posY - 45), (int)(posX + 45), (int)(posY + 55), (int)((int)(45.0f * renderItemScale)), (float)0.1f, (float)(posX - 15), (float)posY, (class_1309)maid);
    }

    public boolean method_25421() {
        return false;
    }

    private void saveConfig() {
        ClientPlayNetworking.send((class_8710)new SaveMaidAIDataPackage(this.maid.method_5628(), this.manager));
    }

    private static /* synthetic */ class_1297 lambda$drawMaid$6(class_1937 world) throws Exception {
        class_1297 e = EntityMaid.TYPE.method_5883(world);
        return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
    }
}

