/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model;

import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ScreenAccessor;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.SkinGuiNumber;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ImageButtonWithId;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TouhouImageButton;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractModelGui<T extends class_1309, E extends IModelInfo>
extends class_437 {
    public static final class_4185.class_4241 NO_PRESS = b -> {};
    private static final class_2960 BG = class_2960.method_60655((String)"touhou_little_maid", (String)"textures/gui/skin_select.png");
    private static final class_2960 SIDE = class_2960.method_60655((String)"touhou_little_maid", (String)"textures/gui/skin_select_side.png");
    private static final class_2960 EMPTY_ICON = class_2960.method_60655((String)"touhou_little_maid", (String)"textures/gui/empty_model_pack_icon.png");
    private static final class_1049 EMPTY_ICON_TEXTURE = new class_1049(EMPTY_ICON);
    protected final T entity;
    private final SkinGuiNumber<E> guiNumber;
    private final List<CustomModelPack<E>> modelPackList;
    private class_342 searchBox;
    private String searchText = "";
    private List<E> filteredModelList = null;
    private boolean isSearchMode = false;
    private List<E> allModelsList = null;

    public AbstractModelGui(T entity, List<CustomModelPack<E>> listPack) {
        super((class_2561)class_2561.method_43470((String)"Custom Model GUI"));
        this.entity = entity;
        this.modelPackList = listPack;
        this.guiNumber = new SkinGuiNumber(this.modelPackList);
        this.setPageIndex(class_3532.method_15340((int)this.getPageIndex(), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
        this.setPackIndex(class_3532.method_15340((int)this.getPackIndex(), (int)0, (int)(this.guiNumber.getPackSize() - 1)));
        this.setRowIndex(class_3532.method_15340((int)this.getRowIndex(), (int)0, (int)this.guiNumber.getRowSize(this.getPackIndex())));
        this.allModelsList = Lists.newArrayList();
        for (CustomModelPack<E> pack : this.modelPackList) {
            this.allModelsList.addAll(pack.getModelList());
        }
    }

    protected abstract void drawLeftEntity(class_332 var1, int var2, int var3, float var4, float var5);

    protected abstract void drawRightEntity(class_332 var1, int var2, int var3, E var4);

    protected abstract void openDetailsGui(T var1, E var2);

    protected abstract void notifyModelChange(T var1, E var2);

    protected abstract void addModelCustomTips(E var1, List<class_2561> var2);

    protected abstract int getPackIndex();

    protected abstract void setPackIndex(int var1);

    protected abstract int getRowIndex();

    protected abstract void setRowIndex(int var1);

    protected abstract int getPageIndex();

    protected abstract void setPageIndex(int var1);

    public void method_25426() {
        this.method_37067();
        this.updateFilteredModelList();
        int startX = this.field_22789 / 2 + 50;
        int startY = this.field_22790 / 2;
        for (int index = 0; index < 7; ++index) {
            this.addTabButton(startX, startY, index);
        }
        this.method_37063((class_364)new TouhouImageButton(startX + 122, startY - 97, 21, 17, 58, 201, 18, BG, b -> this.onClickCloseButton()));
        this.addPageButton(startX, startY);
        this.addModelButton(startX, startY);
        this.addScrollButton(startX, startY);
        class_5250 enableCache = class_2561.method_43471((String)"gui.touhou_little_maid.skin.enable_cache");
        int checkBoxWidth = this.field_22793.method_27525((class_5348)enableCache) + 20;
        int xOffset = (startX - 128) / 2 - checkBoxWidth / 2;
        class_4286 cacheCheckBox = class_4286.method_54787((class_2561)enableCache, (class_327)this.field_22793).method_54789(xOffset, startY - 101).method_54794(((Boolean)MiscConfig.MODEL_ICON_CACHE.get()).booleanValue()).method_54791((checkBox, value) -> MiscConfig.MODEL_ICON_CACHE.set((Object)value)).method_54788();
        this.method_37063((class_364)cacheCheckBox);
        int searchBoxWidth = 216;
        int searchBoxX = startX - 96;
        int searchBoxY = startY + 101;
        this.searchBox = new class_342(this.field_22793, searchBoxX, searchBoxY, searchBoxWidth, 18, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.skin.search"));
        this.searchBox.method_1880(48);
        this.searchBox.method_1858(true);
        this.searchBox.method_1868(-1);
        this.searchBox.method_1852(this.searchText);
        this.searchBox.method_47404((class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.skin.search.hint").method_27692(class_124.field_1063));
        this.searchBox.method_1863(this::onSearchTextChanged);
        this.searchBox.method_1862(this.isSearchMode);
        this.method_37063((class_364)this.searchBox);
        this.addSearchTabButton(startX, startY);
    }

    private void addModelButton(int startX, int startY) {
        List<E> displayList = this.getDisplayModelList();
        int offsetX = -100;
        int offsetY = -35;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        if (fromIndex >= displayList.size()) {
            return;
        }
        int toIndex = Math.min(fromIndex + 55, displayList.size());
        for (IModelInfo modelItem : displayList.subList(fromIndex, toIndex)) {
            this.method_37063((class_364)new TouhouImageButton(startX + offsetX - 8, startY + offsetY - 26, 15, 24, 41, 201, 24, BG, this.onModelButtonClick(modelItem)));
            if ((offsetX += 20) <= 105) continue;
            offsetX = -100;
            offsetY += 30;
        }
    }

    private void addScrollButton(int startX, int startY) {
        TouhouImageButton upButton = new TouhouImageButton(startX - 128 + 253, startY - 73, 14, 10, 24, 15, 10, SIDE, b -> {
            int row = class_3532.method_15340((int)(this.getRowIndex() - 1), (int)0, (int)this.getDisplayRowSize());
            if (row != this.getRowIndex()) {
                this.setRowIndex(row);
                this.method_25426();
            }
        });
        TouhouImageButton downButton = new TouhouImageButton(startX - 128 + 253, startY - 73 + 156, 14, 10, 38, 15, 10, SIDE, b -> {
            int row = class_3532.method_15340((int)(this.getRowIndex() + 1), (int)0, (int)this.getDisplayRowSize());
            if (row != this.getRowIndex()) {
                this.setRowIndex(row);
                this.method_25426();
            }
        });
        this.method_37063((class_364)upButton);
        this.method_37063((class_364)downButton);
    }

    private class_4185.class_4241 onModelButtonClick(E modelItem) {
        return button -> {
            if (AbstractModelGui.method_25442()) {
                this.openDetailsGui(this.entity, modelItem);
            } else {
                this.notifyModelChange(this.entity, modelItem);
            }
        };
    }

    private void addPageButton(int startX, int startY) {
        class_4185 prePage = class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), b -> {
            this.setRowIndex(0);
            this.setPageIndex(class_3532.method_15340((int)(this.getPageIndex() - 1), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
            this.setPackIndex(this.guiNumber.tabToPackIndex(0, this.getPageIndex()));
            this.method_25426();
        }).method_46433(startX - 119, startY - 101).method_46437(20, 20).method_46431();
        class_4185 nextPage = class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), b -> {
            this.setRowIndex(0);
            this.setPageIndex(class_3532.method_15340((int)(this.getPageIndex() + 1), (int)0, (int)(this.guiNumber.getPageSize() - 1)));
            this.setPackIndex(this.guiNumber.tabToPackIndex(0, this.getPageIndex()));
            this.method_25426();
        }).method_46433(startX + 99, startY - 101).method_46437(20, 20).method_46431();
        if (this.getPageIndex() == 0) {
            prePage.field_22763 = false;
        }
        if (this.getPageIndex() == this.guiNumber.getPageSize() - 1) {
            nextPage.field_22763 = false;
        }
        this.method_37063((class_364)prePage);
        this.method_37063((class_364)nextPage);
    }

    private void addTabButton(int startX, int startY, int index) {
        if (index == this.guiNumber.getTabIndex(this.getPackIndex()) && !this.isSearchMode) {
            this.method_37063((class_364)new TouhouImageButton(startX - 98 + 28 * index, startY - 108, 28, 31, 116, 224, 0, BG, NO_PRESS));
            return;
        }
        if (index < this.guiNumber.getTabSize(this.getPackIndex())) {
            this.method_37063((class_364)new ImageButtonWithId(index, startX - 98 + 28 * index, startY - 105, 28, 25, 116, 194, 0, BG, b -> {
                ImageButtonWithId imageButton = (ImageButtonWithId)b;
                int packIndex = this.guiNumber.tabToPackIndex(imageButton.getIndex(), this.getPageIndex());
                this.setRowIndex(0);
                this.setPackIndex(packIndex);
                this.isSearchMode = false;
                this.searchText = "";
                this.method_25426();
            }));
        }
    }

    private void addSearchTabButton(int startX, int startY) {
        int searchTabX = startX - 121;
        int searchTabY = startY + 100;
        if (this.isSearchMode) {
            this.method_37063((class_364)new TouhouImageButton(searchTabX, searchTabY - 4, 24, 26, 145, 194, 0, BG, NO_PRESS));
        } else {
            this.method_37063((class_364)new TouhouImageButton(searchTabX, searchTabY, 24, 21, 145, 220, 0, BG, b -> {
                this.setRowIndex(0);
                this.isSearchMode = true;
                this.method_25426();
            }));
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_57734(partialTicks);
        graphics.method_51448().method_46416(0.0f, 0.0f, -100.0f);
        int middleX = this.field_22789 / 2 + 50;
        int middleY = this.field_22790 / 2;
        this.method_25420(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25302(BG, middleX - 128, middleY - 80, 0, 0, 256, 180);
        graphics.method_25302(SIDE, middleX - 128 + 250, middleY - 80, 0, 0, 24, 180);
        this.drawScrollSide(graphics, middleX, middleY);
        this.drawButton(graphics, mouseX, mouseY, partialTicks);
        this.drawTabIcon(graphics, middleX, middleY);
        this.drawLeftEntity(graphics, middleX, middleY, mouseX, mouseY);
        this.drawEntity(graphics, middleX, middleY);
        this.drawTooltips(graphics, mouseX, mouseY, middleX, middleY);
    }

    private void drawButton(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        for (class_4068 button : ((ScreenAccessor)((Object)this)).tlm$getRenderables()) {
            button.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    private void drawScrollSide(class_332 graphics, int middleX, int middleY) {
        if (this.canScrollCurrentList()) {
            graphics.method_25302(SIDE, middleX - 128 + 254, middleY - 61 + (int)(127.0f * this.getCurrentScrollPosition()), 24, 0, 12, 15);
        } else {
            graphics.method_25302(SIDE, middleX - 128 + 254, middleY - 61 + (int)(127.0f * this.getCurrentScrollPosition()), 36, 0, 12, 15);
        }
    }

    private void drawTabIcon(class_332 graphics, int middleX, int middleY) {
        int size = this.guiNumber.getTabSize(this.getPackIndex());
        for (int index = 0; index < size; ++index) {
            CustomModelPack<E> pack = this.modelPackList.get(this.guiNumber.tabToPackIndex(index, this.getPageIndex()));
            class_2960 icon = pack.getIcon();
            if (icon == null) continue;
            class_1044 iconTexture = class_310.method_1551().method_1531().method_34590(icon, (class_1044)EMPTY_ICON_TEXTURE);
            if (EMPTY_ICON_TEXTURE.equals(iconTexture)) {
                icon = EMPTY_ICON;
            }
            if (pack.getIconAnimation() == CustomModelPack.AnimationState.UNCHECK) {
                this.checkIconAnimation(pack, icon);
            }
            if (pack.getIconAnimation() == CustomModelPack.AnimationState.FALSE) {
                graphics.method_25290(icon, middleX - 92 + 28 * index, middleY - 98, 0.0f, 0.0f, 16, 16, 16, 16);
                continue;
            }
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)icon);
            int time = this.getTickTime() / pack.getIconDelay();
            int iconIndex = time % pack.getIconAspectRatio();
            graphics.method_25290(icon, middleX - 92 + 28 * index, middleY - 98, 0.0f, (float)(iconIndex * 16), 16, 16, 16, 16 * pack.getIconAspectRatio());
        }
    }

    private int getTickTime() {
        return (int)System.currentTimeMillis() / 50;
    }

    private void checkIconAnimation(CustomModelPack<E> pack, class_2960 icon) {
        class_1044 iconText = Screens.getClient((class_437)this).method_1531().method_4619(icon);
        if (iconText instanceof SizeTexture) {
            int height;
            SizeTexture sizeTexture = (SizeTexture)iconText;
            int width = sizeTexture.getWidth();
            if (width >= (height = sizeTexture.getHeight())) {
                pack.setIconAnimation(CustomModelPack.AnimationState.FALSE);
            } else {
                pack.setIconAnimation(CustomModelPack.AnimationState.TRUE);
                pack.setIconAspectRatio(height / width);
            }
        } else {
            pack.setIconAnimation(CustomModelPack.AnimationState.FALSE);
        }
    }

    private void drawEntity(class_332 graphics, int middleX, int middleY) {
        if (!this.isSearchMode) {
            CustomModelPack<E> pack = this.modelPackList.get(this.getPackIndex());
            this.drawPackInfoText(graphics, pack, middleX, middleY);
        }
        List<E> displayList = this.getDisplayModelList();
        int offsetX = -100;
        int offsetY = -38;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        if (fromIndex >= displayList.size()) {
            return;
        }
        int toIndex = Math.min(fromIndex + 55, displayList.size());
        for (IModelInfo modelItem : displayList.subList(fromIndex, toIndex)) {
            this.drawRightEntity(graphics, middleX + offsetX, middleY + offsetY, modelItem);
            if ((offsetX += 20) <= 105) continue;
            offsetX = -100;
            offsetY += 30;
        }
    }

    private void drawPackInfoText(class_332 graphics, CustomModelPack<E> pack, int middleX, int middleY) {
        int offsetY = -80;
        int sideMiddleX = (middleX - 128) / 2;
        class_5250 packName = ParseI18n.parse(pack.getPackName());
        List packSplitName = this.field_22793.method_27527().method_27495((class_5348)packName, middleX - 128 - 20, class_2583.field_24360);
        for (class_5348 properties : packSplitName) {
            graphics.method_25300(this.field_22793, properties.getString(), sideMiddleX, middleY + (offsetY += 10), 0xFFFFFF);
        }
        for (class_2561 str : ParseI18n.parse(pack.getDescription())) {
            List split = this.field_22793.method_27527().method_27495((class_5348)str, middleX - 128 - 20, class_2583.field_24360);
            for (class_5348 properties : split) {
                graphics.method_25300(this.field_22793, properties.getString(), sideMiddleX, middleY + (offsetY += 10), 0x777777);
            }
        }
        if (!pack.getAuthor().isEmpty()) {
            for (List textList : Lists.partition(pack.getAuthor(), (int)2)) {
                graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)textList.toString()).method_27692(class_124.field_1065), sideMiddleX, middleY + (offsetY += 10), 0xFFFFFF);
            }
        }
        if (pack.getVersion() != null) {
            graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43469((String)"gui.touhou_little_maid.skin.text.version", (Object[])new Object[]{pack.getVersion()}).method_27692(class_124.field_1062), sideMiddleX, middleY + (offsetY += 10), 0xFFFFFF);
        }
        if (pack.getDate() != null) {
            graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43469((String)"gui.touhou_little_maid.skin.text.date", (Object[])new Object[]{pack.getDate()}).method_27692(class_124.field_1060), sideMiddleX, middleY + (offsetY += 10), 0xFFFFFF);
        }
        graphics.method_25300(this.field_22793, String.format("%s/%s", this.getPageIndex() + 1, this.guiNumber.getPageSize()), middleX, middleY - 118, 0xFFFFFF);
    }

    private void drawTooltips(class_332 graphics, int mouseX, int mouseY, int middleX, int middleY) {
        boolean yInRange;
        List<E> displayList = this.getDisplayModelList();
        int offsetX = -100;
        int offsetY = -35;
        int fromIndex = this.guiNumber.modelFromIndex(this.getRowIndex());
        if (fromIndex < displayList.size()) {
            int toIndex = Math.min(fromIndex + 55, displayList.size());
            for (IModelInfo modelItem : displayList.subList(fromIndex, toIndex)) {
                boolean isyInRange;
                boolean isxInRange = middleX + offsetX - 8 < mouseX && mouseX < middleX + offsetX + 7;
                boolean bl = isyInRange = middleY + offsetY - 23 < mouseY && mouseY < middleY + offsetY + 1;
                if (isxInRange && isyInRange) {
                    ArrayList<String> str = new ArrayList<String>();
                    str.add(modelItem.getName());
                    str.addAll(modelItem.getDescription());
                    List<class_2561> tooltips = ParseI18n.parse(str);
                    this.addModelCustomTips(modelItem, tooltips);
                    if (!modelItem.getName().equals("{gui.touhou_little_maid.model_gui.easter_egg.encrypt}") && !modelItem.getName().equals("{gui.touhou_little_maid.model_gui.easter_egg.normal}")) {
                        tooltips.add((class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.skin.tooltips.show_details").method_27692(class_124.field_1064));
                    }
                    if (Screens.getClient((class_437)this).field_1690.field_1827) {
                        tooltips.add((class_2561)class_2561.method_43470((String)modelItem.getModelId().toString()).method_27692(class_124.field_1063));
                    }
                    if (this.isSearchMode) {
                        CustomModelPack<IModelInfo> modelPack = this.findPackForModel(modelItem);
                        if (modelPack != null) {
                            tooltips.add((class_2561)ParseI18n.parse(modelPack.getPackName()).method_27692(class_124.field_1078));
                        }
                    } else {
                        CustomModelPack<E> pack = this.modelPackList.get(this.getPackIndex());
                        tooltips.add((class_2561)ParseI18n.parse(pack.getPackName()).method_27692(class_124.field_1078));
                    }
                    graphics.method_51434(this.field_22793, tooltips, mouseX, mouseY);
                }
                if ((offsetX += 20) <= 105) continue;
                offsetX = -100;
                offsetY += 30;
            }
        }
        int size = this.guiNumber.getTabSize(this.getPackIndex());
        for (int index = 0; index < size; ++index) {
            boolean isyInRange;
            boolean isxInRange = middleX - 98 + 28 * index < mouseX && mouseX < middleX - 98 + 28 * index + 28;
            boolean bl = isyInRange = middleY - 108 < mouseY && mouseY < middleY - 108 + 31;
            if (!isxInRange || !isyInRange) continue;
            CustomModelPack<E> hoverPack = this.modelPackList.get(this.guiNumber.tabToPackIndex(index, this.getPageIndex()));
            graphics.method_51438(this.field_22793, (class_2561)ParseI18n.parse(hoverPack.getPackName()), mouseX, mouseY);
        }
        boolean xInRange = middleX + 122 < mouseX && mouseX < middleX + 143;
        boolean bl = yInRange = middleY - 97 < mouseY && mouseY < middleY - 80;
        if (xInRange && yInRange) {
            graphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.skin.button.close"), mouseX, mouseY);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (deltaY != 0.0) {
            int row;
            int index = 0;
            if (deltaY > 0.0) {
                index = 1;
            }
            if (deltaY < 0.0) {
                index = -1;
            }
            if ((row = class_3532.method_15340((int)(this.getRowIndex() - index), (int)0, (int)this.getDisplayRowSize())) != this.getRowIndex()) {
                this.setRowIndex(row);
                this.method_25426();
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.searchBox != null && this.searchBox.method_25402(mouseX, mouseY, button)) {
            this.method_25395((class_364)this.searchBox);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.method_25370() && this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.searchBox != null && this.searchBox.method_25370() && this.searchBox.method_25400(codePoint, modifiers)) {
            return true;
        }
        return super.method_25400(codePoint, modifiers);
    }

    private void onSearchTextChanged(String text) {
        if (!this.searchText.equals(text)) {
            this.searchText = text;
            this.setRowIndex(0);
            this.method_25426();
        }
    }

    private void updateFilteredModelList() {
        if (this.isSearchMode) {
            if (StringUtils.isBlank((CharSequence)this.searchText)) {
                this.filteredModelList = this.allModelsList;
            } else {
                String lowerSearchText = this.searchText.toLowerCase(Locale.ENGLISH).trim();
                this.filteredModelList = this.allModelsList.stream().filter(model -> this.filterKeyWord(model, lowerSearchText)).collect(Collectors.toList());
            }
        } else {
            this.filteredModelList = null;
        }
    }

    private boolean filterKeyWord(E model, String keyword) {
        String modelName = ParseI18n.getI18nValue(model.getName());
        if (modelName.toLowerCase(Locale.ENGLISH).contains(keyword)) {
            return true;
        }
        for (String desc : model.getDescription()) {
            String descText = ParseI18n.getI18nValue(desc);
            if (!descText.toLowerCase(Locale.ENGLISH).contains(keyword)) continue;
            return true;
        }
        String modelId = model.getModelId().toString().toLowerCase(Locale.ENGLISH);
        return modelId.contains(keyword);
    }

    private List<E> getDisplayModelList() {
        if (this.isSearchMode) {
            return Objects.requireNonNullElseGet(this.filteredModelList, () -> Objects.requireNonNullElse(this.allModelsList, Collections.emptyList()));
        }
        return this.modelPackList.get(this.getPackIndex()).getModelList();
    }

    private int getDisplayRowSize() {
        List<E> displayList = this.getDisplayModelList();
        if (displayList == null || displayList.isEmpty()) {
            return 0;
        }
        int row = (displayList.size() - 1) / 11 + 1;
        return Math.max(row - 5, 0);
    }

    private CustomModelPack<E> findPackForModel(E model) {
        for (CustomModelPack<E> pack : this.modelPackList) {
            if (!pack.getModelList().contains(model)) continue;
            return pack;
        }
        return null;
    }

    private boolean canScrollCurrentList() {
        if (this.isSearchMode) {
            List<E> displayList = this.getDisplayModelList();
            int modelSize = displayList.size() - 11 * this.getRowIndex();
            return modelSize > 55;
        }
        return this.guiNumber.canScroll(this.getPackIndex(), this.getRowIndex());
    }

    private float getCurrentScrollPosition() {
        if (this.isSearchMode) {
            List<E> displayList = this.getDisplayModelList();
            if (displayList.isEmpty()) {
                return 0.0f;
            }
            int totalRows = (displayList.size() - 1) / 11;
            int maxScroll = Math.max(totalRows - 4, 0);
            if (maxScroll == 0) {
                return 0.0f;
            }
            return class_3532.method_15363((float)((float)((double)this.getRowIndex() * (1.0 / (double)maxScroll))), (float)0.0f, (float)1.0f);
        }
        return this.guiNumber.getCurrentScroll(this.getPackIndex(), this.getRowIndex());
    }

    protected void onClickCloseButton() {
        this.method_25419();
    }
}

