/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Objects;
import net.minecraft.class_1088;
import net.minecraft.class_1308;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2185;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5253;
import net.minecraft.class_5599;
import net.minecraft.class_6880;
import net.minecraft.class_7833;
import net.minecraft.class_9307;
import net.minecraft.class_9334;

public class LayerMaidBanner
extends class_3887<class_1308, BedrockModel<class_1308>> {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"touhou_little_maid", (String)"textures/bedrock/entity/maid_banner.png");
    private final EntityMaidRenderer renderer;
    private final SimpleBedrockModel<EntityMaid> bannerModel;

    public LayerMaidBanner(EntityMaidRenderer renderer, class_5599 modelSet) {
        super((class_3883)renderer);
        this.renderer = renderer;
        this.bannerModel = Objects.requireNonNull(BedrockModelLoader.getModel(BedrockModelLoader.MAID_BANNER));
    }

    public void render(class_4587 matrixStack, class_4597 bufferIn, int packedLightIn, class_1308 mob, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IMaid maid = IMaid.convert(mob);
        if (maid == null) {
            return;
        }
        class_1799 stack = maid.getBackpackShowItem();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1746) {
            EntityMaid entityMaid;
            class_1746 bannerItem = (class_1746)class_17922;
            if (!this.renderer.getMainInfo().isShowBackpack() || mob.method_6113() || mob.method_5767()) {
                return;
            }
            if (maid instanceof EntityMaid && !(entityMaid = (EntityMaid)maid).getConfigManager().isShowBackItem()) {
                return;
            }
            matrixStack.method_22903();
            matrixStack.method_22904(0.0, 0.5, 0.025);
            matrixStack.method_22905(0.5f, 0.5f, 0.5f);
            matrixStack.method_22907(class_7833.field_40713.rotationDegrees(5.0f));
            class_4588 buffer = bufferIn.getBuffer(class_1921.method_23578((class_2960)TEXTURE));
            this.bannerModel.method_2828(matrixStack, buffer, packedLightIn, class_4608.field_21444, -1);
            class_9307 patterns = (class_9307)maid.getBackpackShowItem().method_57824(class_9334.field_49619);
            class_1767 dyeColor = ((class_2185)bannerItem.method_7711()).method_9303();
            if (patterns != null) {
                this.renderPatterns(matrixStack, bufferIn, packedLightIn, this.bannerModel.getPart("banner"), patterns, dyeColor);
            }
            matrixStack.method_22909();
        }
    }

    private void renderPatterns(class_4587 poseStack, class_4597 bufferSource, int packedLight, BedrockPart banner, class_9307 patterns, class_1767 dyeColor) {
        banner.render(poseStack, class_1088.field_20847.method_30001(bufferSource, class_1921::method_23572, false), packedLight, class_4608.field_21444);
        this.renderPatternLayer(poseStack, bufferSource, packedLight, banner, class_4722.field_49769, dyeColor);
        for (int i = 0; i < 16 && i < patterns.comp_2428().size(); ++i) {
            class_9307.class_9308 layer = (class_9307.class_9308)patterns.comp_2428().get(i);
            class_4730 material = class_4722.method_33081((class_6880)layer.comp_2429());
            this.renderPatternLayer(poseStack, bufferSource, packedLight, banner, material, layer.comp_2430());
        }
    }

    private void renderPatternLayer(class_4587 poseStack, class_4597 buffer, int packedLight, BedrockPart banner, class_4730 material, class_1767 color) {
        int packedColor = color.method_7787();
        float red = (float)class_5253.class_5254.method_27765((int)packedColor) / 255.0f;
        float green = (float)class_5253.class_5254.method_27766((int)packedColor) / 255.0f;
        float blue = (float)class_5253.class_5254.method_27767((int)packedColor) / 255.0f;
        banner.render(poseStack, material.method_24145(buffer, class_1921::method_23588), packedLight, class_4608.field_21444, red, green, blue, 1.0f);
    }
}

