/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.client.render.MaidRenderState;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGarageKit;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.class_898;

public class TileEntityGarageKitRenderer
implements class_827<TileEntityGarageKit> {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"touhou_little_maid", (String)"textures/bedrock/block/statue_base.png");
    private final SimpleBedrockModel<class_1297> BASE_MODEL = BedrockModelLoader.getModel(BedrockModelLoader.STATUE_BASE);

    public TileEntityGarageKitRenderer(class_5614.class_5615 context) {
    }

    public void render(TileEntityGarageKit te, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        poseStack.method_22903();
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        poseStack.method_22904(1.0, 1.5, 1.0);
        poseStack.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
        class_4588 buffer = bufferIn.getBuffer(class_1921.method_23578((class_2960)TEXTURE));
        this.BASE_MODEL.method_60879(poseStack, buffer, combinedLightIn, combinedOverlayIn);
        poseStack.method_22909();
        class_2487 data = te.getExtraData();
        class_638 world = class_310.method_1551().field_1687;
        if (data.method_33133() || world == null) {
            return;
        }
        class_1299.method_5898((String)data.method_10558("id")).ifPresent(arg_0 -> this.lambda$render$0(te, poseStack, bufferIn, combinedLightIn, data, (class_1937)world, arg_0));
    }

    private void renderEntity(TileEntityGarageKit te, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, class_2487 data, class_1937 world, class_1299<?> type) throws ExecutionException {
        class_1297 entity;
        if (type.equals(InitEntities.MAID)) {
            long posId = te.method_11016().method_10063();
            entity = (class_1297)EntityCacheUtil.STATUE_CACHE.get((Object)posId, () -> new EntityMaid(world));
        } else {
            entity = (class_1297)EntityCacheUtil.ENTITY_CACHE.get(type, () -> {
                class_1297 e = type.method_5883(world);
                return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
            });
        }
        entity.method_5651(data);
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            EntityCacheUtil.clearMaidDataResidue(maid, true);
            maid.renderState = MaidRenderState.GARAGE_KIT;
            maid.field_6012 = YsmCompat.isInstalled() && maid.isYsmModel() ? (int)world.method_8510() : 0;
        }
        poseStack.method_22903();
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        poseStack.method_22904(1.0, 0.21328125, 1.0);
        switch (te.getFacing()) {
            case field_11034: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
            case field_11039: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
                break;
            }
            case field_11035: {
                break;
            }
            default: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            }
        }
        class_898 render = class_310.method_1551().method_1561();
        boolean isShowHitBox = render.method_3958();
        render.method_3955(false);
        render.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, bufferIn, combinedLightIn);
        render.method_3955(isShowHitBox);
        poseStack.method_22909();
    }

    private /* synthetic */ void lambda$render$0(TileEntityGarageKit te, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, class_2487 data, class_1937 world, class_1299 type) {
        try {
            this.renderEntity(te, poseStack, bufferIn, combinedLightIn, data, world, type);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }
}

