/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockModelPOJO;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockVersion;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.CubesItem;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.CustomJsAnimationManger;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionManager;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache.CacheIconManager;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.FilePackTexture;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.ZipPackTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.GeckoModelLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.LanguageLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.models.ChairModels;
import com.github.tartaricacid.touhoulittlemaid.client.resource.models.MaidModels;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.client.sound.CustomSoundLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.file.AnimationFile;
import com.github.tartaricacid.touhoulittlemaid.util.ZipFileCheck;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1308;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Environment(value=EnvType.CLIENT)
public class CustomPackLoader {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(CubesItem.class, (Object)new CubesItem.Deserializer()).create();
    public static final MaidModels MAID_MODELS = MaidModels.getInstance();
    public static final ChairModels CHAIR_MODELS = ChairModels.getInstance();
    private static final Set<class_2960> TMP_REGISTER_TEXTURE = Sets.newHashSet();
    private static final String CUSTOM_PACK_DIR_NAME = "tlm_custom_pack";
    public static final Path PACK_FOLDER = Paths.get(class_310.method_1551().field_1697.toURI()).resolve("tlm_custom_pack");
    private static final Marker MARKER = MarkerManager.getMarker((String)"CustomPackLoader");
    private static final Pattern DOMAIN = Pattern.compile("^assets/([\\w.]+)/$");

    public static void reloadPacks() {
        CustomJsAnimationManger.clearAll();
        ConditionManager.clear();
        MAID_MODELS.clearAll();
        CHAIR_MODELS.clearAll();
        TMP_REGISTER_TEXTURE.clear();
        LanguageLoader.clear();
        CustomSoundLoader.clear();
        CacheIconManager.clearCache();
        CustomPackLoader.loadPacks(PACK_FOLDER.toFile());
        LanguageLoader.loadDownloadInfoLanguages();
        MAID_MODELS.sortPackList();
        CHAIR_MODELS.sortPackList();
        CustomSoundLoader.sortSoundPack();
    }

    private static void loadPacks(File packFolder) {
        File[] files = packFolder.listFiles((dir, name) -> true);
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isFile() && file.getName().endsWith(".zip")) {
                try {
                    if (ZipFileCheck.isZipFile(file)) {
                        CustomPackLoader.readModelFromZipFile(file);
                    } else {
                        TouhouLittleMaid.LOGGER.error("{} file is corrupt and cannot be loaded.", (Object)file.getName());
                    }
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
            if (!file.isDirectory()) continue;
            CustomPackLoader.readModelFromFolder(file);
        }
    }

    public static void readModelFromFolder(File root) {
        try {
            File[] domainFiles = root.toPath().resolve("assets").toFile().listFiles((dir, name) -> true);
            if (domainFiles == null) {
                return;
            }
            for (File domainDir : domainFiles) {
                if (!domainDir.isDirectory()) continue;
                Path rootPath = root.toPath();
                String domain = domainDir.getName();
                CustomPackLoader.loadMaidModelPack(rootPath, domain);
                CustomPackLoader.loadChairModelPack(rootPath, domain);
                LanguageLoader.readLanguageFile(rootPath, domain);
                CustomSoundLoader.loadSoundPack(rootPath, domain);
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    public static void readModelFromZipFile(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> iteration = zipFile.entries();
            while (iteration.hasMoreElements()) {
                String filePath = iteration.nextElement().getName();
                Matcher matcher = DOMAIN.matcher(filePath);
                if (matcher.find()) {
                    String domain = matcher.group(1);
                    CustomPackLoader.loadMaidModelPack(zipFile, domain);
                    CustomPackLoader.loadChairModelPack(zipFile, domain);
                    CustomSoundLoader.loadSoundPack(zipFile, domain);
                    continue;
                }
                LanguageLoader.readLanguageFile(zipFile, filePath);
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    private static void loadMaidModelPack(Path rootPath, String domain) {
        TouhouLittleMaid.LOGGER.debug(MARKER, "Touhou little maid mod's model is loading...");
        File file = rootPath.resolve("assets").resolve(domain).resolve(MAID_MODELS.getJsonFileName()).toFile();
        if (!file.isFile()) {
            return;
        }
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            CustomModelPack pack = (CustomModelPack)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), new TypeToken<CustomModelPack<MaidModelInfo>>(){}.getType());
            pack.decorate(domain);
            if (pack.getIcon() != null) {
                CustomPackLoader.registerFilePackTexture(rootPath, pack.getIcon());
            }
            for (MaidModelInfo maidModelItem : pack.getModelList()) {
                if (maidModelItem.isGeckoModel()) {
                    CustomPackLoader.loadGeckoMaidModelElement(rootPath, maidModelItem);
                    continue;
                }
                CustomPackLoader.loadMaidModelElement(rootPath, maidModelItem);
            }
            MAID_MODELS.addPack(pack);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Fail to parse model pack in domain {}", (Object)domain);
            e.printStackTrace();
        }
        TouhouLittleMaid.LOGGER.debug(MARKER, "Touhou little maid mod's model is loaded");
    }

    private static void loadMaidModelElement(Path rootPath, MaidModelInfo maidModelItem) {
        BedrockModel<class_1308> modelJson = CustomPackLoader.loadMaidModel(rootPath, maidModelItem.getModel());
        CustomPackLoader.registerFilePackTexture(rootPath, maidModelItem.getTexture());
        List<Object> animations = CustomJsAnimationManger.getCustomAnimation(rootPath, (IModelInfo)maidModelItem);
        if (modelJson != null) {
            if (maidModelItem.getEasterEgg() != null && StringUtils.isNotBlank((CharSequence)maidModelItem.getEasterEgg().getTag())) {
                CustomPackLoader.putMaidEasterEggData(maidModelItem, modelJson, animations);
            } else {
                CustomPackLoader.putMaidModelData(maidModelItem, modelJson, animations);
            }
            TouhouLittleMaid.LOGGER.debug(MARKER, "Loaded model: {}", (Object)maidModelItem.getModel());
        }
    }

    private static void loadGeckoMaidModelElement(Path rootPath, MaidModelInfo maidModelItem) throws IOException {
        class_2960 uid = maidModelItem.getModelId();
        class_2960 modelLocation = maidModelItem.getModel();
        File modelFile = rootPath.resolve("assets").resolve(modelLocation.method_12836()).resolve(modelLocation.method_12832()).toFile();
        if (!modelFile.isFile()) {
            return;
        }
        try (InputStream fileInputStream = Files.newInputStream(modelFile.toPath(), new OpenOption[0]);){
            GeckoModelLoader.registerGeo(uid, fileInputStream);
        }
        CustomPackLoader.registerFilePackTexture(rootPath, maidModelItem.getTexture());
        List<class_2960> animation = maidModelItem.getAnimation();
        if (animation == null || animation.isEmpty()) {
            return;
        }
        AnimationFile animationData = new AnimationFile();
        for (class_2960 animationPath : animation) {
            if (animationPath.equals((Object)GeckoModelLoader.DEFAULT_MAID_ANIMATION)) break;
            File animationFile = rootPath.resolve("assets").resolve(animationPath.method_12836()).resolve(animationPath.method_12832()).toFile();
            if (!animationFile.isFile()) continue;
            InputStream fileInputStream = Files.newInputStream(animationFile.toPath(), new OpenOption[0]);
            try {
                GeckoModelLoader.mergeAnimationFile(fileInputStream, animationData);
            }
            finally {
                if (fileInputStream == null) continue;
                fileInputStream.close();
            }
        }
        GeckoModelLoader.registerMaidAnimations(uid, animationData);
        if (maidModelItem.getEasterEgg() != null && StringUtils.isNotBlank((CharSequence)maidModelItem.getEasterEgg().getTag())) {
            CustomPackLoader.putMaidEasterEggData(maidModelItem, null, null);
        } else {
            MAID_MODELS.putInfo(uid.toString(), maidModelItem);
        }
        TouhouLittleMaid.LOGGER.debug(MARKER, "Loaded model: {}", (Object)maidModelItem.getModel());
    }

    private static void loadGeckoChairModelElement(Path rootPath, ChairModelInfo chairModelItem) throws IOException {
        class_2960 uid = chairModelItem.getModelId();
        class_2960 modelLocation = chairModelItem.getModel();
        File modelFile = rootPath.resolve("assets").resolve(modelLocation.method_12836()).resolve(modelLocation.method_12832()).toFile();
        if (!modelFile.isFile()) {
            return;
        }
        try (InputStream fileInputStream = Files.newInputStream(modelFile.toPath(), new OpenOption[0]);){
            GeckoModelLoader.registerGeo(uid, fileInputStream);
        }
        CustomPackLoader.registerFilePackTexture(rootPath, chairModelItem.getTexture());
        List<class_2960> animation = chairModelItem.getAnimation();
        if (animation == null || animation.isEmpty()) {
            return;
        }
        AnimationFile animationData = new AnimationFile();
        for (class_2960 animationPath : animation) {
            if (animationPath.equals((Object)GeckoModelLoader.DEFAULT_CHAIR_ANIMATION)) break;
            File animationFile = rootPath.resolve("assets").resolve(animationPath.method_12836()).resolve(animationPath.method_12832()).toFile();
            if (!animationFile.isFile()) continue;
            InputStream fileInputStream = Files.newInputStream(animationFile.toPath(), new OpenOption[0]);
            try {
                GeckoModelLoader.mergeAnimationFile(fileInputStream, animationData);
            }
            finally {
                if (fileInputStream == null) continue;
                fileInputStream.close();
            }
        }
        GeckoModelLoader.registerChairAnimations(uid, animationData);
        CHAIR_MODELS.putInfo(uid.toString(), chairModelItem);
        TouhouLittleMaid.LOGGER.debug(MARKER, "Loaded model: {}", (Object)chairModelItem.getModel());
    }

    private static void loadMaidModelPack(ZipFile zipFile, String domain) {
        TouhouLittleMaid.LOGGER.debug(MARKER, "Touhou little maid mod's model is loading...");
        ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", domain, MAID_MODELS.getJsonFileName()));
        if (entry == null) {
            return;
        }
        try (InputStream stream = zipFile.getInputStream(entry);){
            CustomModelPack pack = (CustomModelPack)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), new TypeToken<CustomModelPack<MaidModelInfo>>(){}.getType());
            pack.decorate(domain);
            if (pack.getIcon() != null) {
                CustomPackLoader.registerZipPackTexture(zipFile.getName(), pack.getIcon());
            }
            for (MaidModelInfo maidModelItem : pack.getModelList()) {
                if (maidModelItem.isGeckoModel()) {
                    CustomPackLoader.loadGeckoMaidModelElement(zipFile, maidModelItem);
                    continue;
                }
                CustomPackLoader.loadMaidModelElement(zipFile, maidModelItem);
            }
            MAID_MODELS.addPack(pack);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Fail to parse model pack in domain {}", (Object)domain);
            e.printStackTrace();
        }
        TouhouLittleMaid.LOGGER.debug(MARKER, "Touhou little maid mod's model is loaded");
    }

    private static void loadMaidModelElement(ZipFile zipFile, MaidModelInfo maidModelItem) {
        BedrockModel<class_1308> modelJson = CustomPackLoader.loadMaidModel(zipFile, maidModelItem.getModel());
        CustomPackLoader.registerZipPackTexture(zipFile.getName(), maidModelItem.getTexture());
        List<Object> animations = CustomJsAnimationManger.getCustomAnimation(zipFile, (IModelInfo)maidModelItem);
        if (modelJson != null) {
            if (maidModelItem.getEasterEgg() != null && StringUtils.isNotBlank((CharSequence)maidModelItem.getEasterEgg().getTag())) {
                CustomPackLoader.putMaidEasterEggData(maidModelItem, modelJson, animations);
            } else {
                CustomPackLoader.putMaidModelData(maidModelItem, modelJson, animations);
            }
            TouhouLittleMaid.LOGGER.debug(MARKER, "Loaded model: {}", (Object)maidModelItem.getModel());
        }
    }

    private static void loadGeckoMaidModelElement(ZipFile zipFile, MaidModelInfo maidModelItem) throws IOException {
        class_2960 uid = maidModelItem.getModelId();
        class_2960 modelLocation = maidModelItem.getModel();
        String path = String.format("assets/%s/%s", modelLocation.method_12836(), modelLocation.method_12832());
        ZipEntry modelZipEntry = zipFile.getEntry(path);
        if (modelZipEntry == null) {
            return;
        }
        try (InputStream zipFileInputStream = zipFile.getInputStream(modelZipEntry);){
            GeckoModelLoader.registerGeo(uid, zipFileInputStream);
        }
        CustomPackLoader.registerZipPackTexture(zipFile.getName(), maidModelItem.getTexture());
        List<class_2960> animation = maidModelItem.getAnimation();
        if (animation == null || animation.isEmpty()) {
            return;
        }
        AnimationFile animationData = new AnimationFile();
        for (class_2960 animationPath : animation) {
            if (animationPath.equals((Object)GeckoModelLoader.DEFAULT_MAID_ANIMATION)) break;
            ZipEntry animationZipEntry = zipFile.getEntry(String.format("assets/%s/%s", animationPath.method_12836(), animationPath.method_12832()));
            if (animationZipEntry == null) continue;
            InputStream zipFileInputStream = zipFile.getInputStream(animationZipEntry);
            try {
                GeckoModelLoader.mergeAnimationFile(zipFileInputStream, animationData);
            }
            finally {
                if (zipFileInputStream == null) continue;
                zipFileInputStream.close();
            }
        }
        GeckoModelLoader.registerMaidAnimations(uid, animationData);
        if (maidModelItem.getEasterEgg() != null && StringUtils.isNotBlank((CharSequence)maidModelItem.getEasterEgg().getTag())) {
            CustomPackLoader.putMaidEasterEggData(maidModelItem, null, null);
        } else {
            MAID_MODELS.putInfo(uid.toString(), maidModelItem);
        }
        TouhouLittleMaid.LOGGER.debug(MARKER, "Loaded model: {}", (Object)maidModelItem.getModel());
    }

    private static void loadGeckoChairModelElement(ZipFile zipFile, ChairModelInfo chairModelItem) throws IOException {
        class_2960 uid = chairModelItem.getModelId();
        class_2960 modelLocation = chairModelItem.getModel();
        String path = String.format("assets/%s/%s", modelLocation.method_12836(), modelLocation.method_12832());
        ZipEntry modelZipEntry = zipFile.getEntry(path);
        if (modelZipEntry == null) {
            return;
        }
        try (InputStream zipFileInputStream = zipFile.getInputStream(modelZipEntry);){
            GeckoModelLoader.registerGeo(uid, zipFileInputStream);
        }
        CustomPackLoader.registerZipPackTexture(zipFile.getName(), chairModelItem.getTexture());
        List<class_2960> animation = chairModelItem.getAnimation();
        if (animation == null || animation.isEmpty()) {
            return;
        }
        AnimationFile animationData = new AnimationFile();
        for (class_2960 animationPath : animation) {
            if (animationPath.equals((Object)GeckoModelLoader.DEFAULT_CHAIR_ANIMATION)) break;
            ZipEntry animationZipEntry = zipFile.getEntry(String.format("assets/%s/%s", animationPath.method_12836(), animationPath.method_12832()));
            if (animationZipEntry == null) continue;
            InputStream zipFileInputStream = zipFile.getInputStream(animationZipEntry);
            try {
                GeckoModelLoader.mergeAnimationFile(zipFileInputStream, animationData);
            }
            finally {
                if (zipFileInputStream == null) continue;
                zipFileInputStream.close();
            }
        }
        GeckoModelLoader.registerChairAnimations(uid, animationData);
        CHAIR_MODELS.putInfo(uid.toString(), chairModelItem);
        TouhouLittleMaid.LOGGER.debug(MARKER, "Loaded model: {}", (Object)chairModelItem.getModel());
    }

    private static void putMaidEasterEggData(MaidModelInfo maidModelItem, @Nullable BedrockModel<class_1308> modelJson, @Nullable List<Object> animations) {
        MaidModelInfo.EasterEgg easterEgg = maidModelItem.getEasterEgg();
        MaidModels.ModelData data = new MaidModels.ModelData(modelJson, maidModelItem, animations);
        if (easterEgg.isEncrypt()) {
            MAID_MODELS.putEasterEggEncryptTagModel(easterEgg.getTag(), data);
        } else {
            MAID_MODELS.putEasterEggNormalTagModel(easterEgg.getTag(), data);
        }
    }

    private static void putMaidModelData(MaidModelInfo maidModelItem, BedrockModel<class_1308> modelJson, List<Object> animations) {
        String id = maidModelItem.getModelId().toString();
        MAID_MODELS.putModel(id, modelJson);
        MAID_MODELS.putInfo(id, maidModelItem);
        if (animations != null && !animations.isEmpty()) {
            MAID_MODELS.putAnimation(id, animations);
        }
    }

    private static void loadChairModelPack(Path rootPath, String domain) {
        TouhouLittleMaid.LOGGER.debug(MARKER, "Touhou little maid mod's model is loading...");
        File file = rootPath.resolve("assets").resolve(domain).resolve(CHAIR_MODELS.getJsonFileName()).toFile();
        if (!file.isFile()) {
            return;
        }
        try (InputStream stream2 = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            CustomModelPack pack = (CustomModelPack)GSON.fromJson((Reader)new InputStreamReader(stream2, StandardCharsets.UTF_8), new TypeToken<CustomModelPack<ChairModelInfo>>(){}.getType());
            pack.decorate(domain);
            if (pack.getIcon() != null) {
                CustomPackLoader.registerFilePackTexture(rootPath, pack.getIcon());
            }
            for (ChairModelInfo chairModelItem : pack.getModelList()) {
                if (chairModelItem.isGeckoModel()) {
                    CustomPackLoader.loadGeckoChairModelElement(rootPath, chairModelItem);
                    continue;
                }
                CustomPackLoader.loadChairModelElement(rootPath, chairModelItem);
            }
            CHAIR_MODELS.addPack(pack);
        }
        catch (IOException stream2) {
        }
        catch (JsonSyntaxException e) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Fail to parse model pack in domain {}", (Object)domain);
            e.printStackTrace();
        }
        TouhouLittleMaid.LOGGER.debug(MARKER, "Touhou little maid mod's model is loaded");
    }

    private static void loadChairModelElement(Path rootPath, ChairModelInfo chairModelItem) {
        BedrockModel<EntityChair> modelJson = CustomPackLoader.loadChairModel(rootPath, chairModelItem.getModel());
        CustomPackLoader.registerFilePackTexture(rootPath, chairModelItem.getTexture());
        List<Object> animations = CustomJsAnimationManger.getCustomAnimation(rootPath, (IModelInfo)chairModelItem);
        if (modelJson != null) {
            String id = chairModelItem.getModelId().toString();
            CHAIR_MODELS.putModel(id, modelJson);
            CHAIR_MODELS.putInfo(id, chairModelItem);
            if (animations != null && !animations.isEmpty()) {
                CHAIR_MODELS.putAnimation(id, animations);
            }
            TouhouLittleMaid.LOGGER.debug(MARKER, "Loaded model: {}", (Object)chairModelItem.getModel());
        }
    }

    private static void loadChairModelPack(ZipFile zipFile, String domain) {
        TouhouLittleMaid.LOGGER.debug(MARKER, "Touhou little maid mod's model is loading...");
        ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", domain, CHAIR_MODELS.getJsonFileName()));
        if (entry == null) {
            return;
        }
        try (InputStream stream2 = zipFile.getInputStream(entry);){
            CustomModelPack pack = (CustomModelPack)GSON.fromJson((Reader)new InputStreamReader(stream2, StandardCharsets.UTF_8), new TypeToken<CustomModelPack<ChairModelInfo>>(){}.getType());
            pack.decorate(domain);
            if (pack.getIcon() != null) {
                CustomPackLoader.registerZipPackTexture(zipFile.getName(), pack.getIcon());
            }
            for (ChairModelInfo chairModelItem : pack.getModelList()) {
                if (chairModelItem.isGeckoModel()) {
                    CustomPackLoader.loadGeckoChairModelElement(zipFile, chairModelItem);
                    continue;
                }
                CustomPackLoader.loadChairModelElement(zipFile, chairModelItem);
            }
            CHAIR_MODELS.addPack(pack);
        }
        catch (IOException stream2) {
        }
        catch (JsonSyntaxException e) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Fail to parse model pack in domain {}", (Object)domain);
            e.printStackTrace();
        }
        TouhouLittleMaid.LOGGER.debug(MARKER, "Touhou little maid mod's model is loaded");
    }

    private static void loadChairModelElement(ZipFile zipFile, ChairModelInfo chairModelItem) {
        BedrockModel<EntityChair> modelJson = CustomPackLoader.loadChairModel(zipFile, chairModelItem.getModel());
        CustomPackLoader.registerZipPackTexture(zipFile.getName(), chairModelItem.getTexture());
        List<Object> animations = CustomJsAnimationManger.getCustomAnimation(zipFile, (IModelInfo)chairModelItem);
        if (modelJson != null) {
            String id = chairModelItem.getModelId().toString();
            CHAIR_MODELS.putModel(id, modelJson);
            CHAIR_MODELS.putInfo(id, chairModelItem);
            if (animations != null && !animations.isEmpty()) {
                CHAIR_MODELS.putAnimation(id, animations);
            }
            TouhouLittleMaid.LOGGER.debug(MARKER, "Loaded model: {}", (Object)chairModelItem.getModel());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static BedrockModel<class_1308> loadMaidModel(Path rootPath, class_2960 modelLocation) {
        File file = rootPath.resolve("assets").resolve(modelLocation.method_12836()).resolve(modelLocation.method_12832()).toFile();
        if (!file.isFile()) {
            return null;
        }
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            BedrockModelPOJO pojo = (BedrockModelPOJO)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), BedrockModelPOJO.class);
            if (BedrockVersion.isLegacyVersion(pojo)) {
                if (pojo.getGeometryModelLegacy() != null) {
                    BedrockModel<class_1308> bedrockModel = new BedrockModel<class_1308>(pojo, BedrockVersion.LEGACY);
                    return bedrockModel;
                }
                TouhouLittleMaid.LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                BedrockModel<class_1308> bedrockModel = null;
                return bedrockModel;
            }
            if (BedrockVersion.isNewVersion(pojo)) {
                if (pojo.getGeometryModelNew() != null) {
                    BedrockModel<class_1308> bedrockModel = new BedrockModel<class_1308>(pojo, BedrockVersion.NEW);
                    return bedrockModel;
                }
                TouhouLittleMaid.LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                BedrockModel<class_1308> bedrockModel = null;
                return bedrockModel;
            }
            TouhouLittleMaid.LOGGER.warn(MARKER, "{} model version is not 1.10.0 or 1.12.0", (Object)modelLocation);
            return null;
        }
        catch (IOException ioe) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Failed to load model: {}", (Object)modelLocation);
            ioe.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static BedrockModel<class_1308> loadMaidModel(ZipFile zipFile, class_2960 modelLocation) {
        String path = String.format("assets/%s/%s", modelLocation.method_12836(), modelLocation.method_12832());
        ZipEntry entry = zipFile.getEntry(path);
        if (entry == null) {
            return null;
        }
        try (InputStream stream = zipFile.getInputStream(entry);){
            BedrockModelPOJO pojo = (BedrockModelPOJO)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), BedrockModelPOJO.class);
            if (BedrockVersion.isLegacyVersion(pojo)) {
                if (pojo.getGeometryModelLegacy() != null) {
                    BedrockModel<class_1308> bedrockModel = new BedrockModel<class_1308>(pojo, BedrockVersion.LEGACY);
                    return bedrockModel;
                }
                TouhouLittleMaid.LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                BedrockModel<class_1308> bedrockModel = null;
                return bedrockModel;
            }
            if (BedrockVersion.isNewVersion(pojo)) {
                if (pojo.getGeometryModelNew() != null) {
                    BedrockModel<class_1308> bedrockModel = new BedrockModel<class_1308>(pojo, BedrockVersion.NEW);
                    return bedrockModel;
                }
                TouhouLittleMaid.LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                BedrockModel<class_1308> bedrockModel = null;
                return bedrockModel;
            }
            TouhouLittleMaid.LOGGER.warn(MARKER, "{} model version is not 1.10.0 or 1.12.0", (Object)modelLocation);
            return null;
        }
        catch (IOException ioe) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Failed to load model: {}", (Object)modelLocation);
            ioe.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static BedrockModel<EntityChair> loadChairModel(Path rootPath, class_2960 modelLocation) {
        File file = rootPath.resolve("assets").resolve(modelLocation.method_12836()).resolve(modelLocation.method_12832()).toFile();
        if (!file.isFile()) {
            return null;
        }
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            BedrockModelPOJO pojo = (BedrockModelPOJO)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), BedrockModelPOJO.class);
            if (BedrockVersion.isLegacyVersion(pojo)) {
                if (pojo.getGeometryModelLegacy() != null) {
                    BedrockModel<EntityChair> bedrockModel = new BedrockModel<EntityChair>(pojo, BedrockVersion.LEGACY);
                    return bedrockModel;
                }
                TouhouLittleMaid.LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                BedrockModel<EntityChair> bedrockModel = null;
                return bedrockModel;
            }
            if (BedrockVersion.isNewVersion(pojo)) {
                if (pojo.getGeometryModelNew() != null) {
                    BedrockModel<EntityChair> bedrockModel = new BedrockModel<EntityChair>(pojo, BedrockVersion.NEW);
                    return bedrockModel;
                }
                TouhouLittleMaid.LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                BedrockModel<EntityChair> bedrockModel = null;
                return bedrockModel;
            }
            TouhouLittleMaid.LOGGER.warn(MARKER, "{} model version is not 1.10.0 or 1.12.0", (Object)modelLocation);
            return null;
        }
        catch (IOException ioe) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Failed to load model: {}", (Object)modelLocation);
            ioe.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static BedrockModel<EntityChair> loadChairModel(ZipFile zipFile, class_2960 modelLocation) {
        String path = String.format("assets/%s/%s", modelLocation.method_12836(), modelLocation.method_12832());
        ZipEntry entry = zipFile.getEntry(path);
        if (entry == null) {
            return null;
        }
        try (InputStream stream = zipFile.getInputStream(entry);){
            BedrockModelPOJO pojo = (BedrockModelPOJO)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), BedrockModelPOJO.class);
            if (BedrockVersion.isLegacyVersion(pojo)) {
                if (pojo.getGeometryModelLegacy() != null) {
                    BedrockModel<EntityChair> bedrockModel = new BedrockModel<EntityChair>(pojo, BedrockVersion.LEGACY);
                    return bedrockModel;
                }
                TouhouLittleMaid.LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                BedrockModel<EntityChair> bedrockModel = null;
                return bedrockModel;
            }
            if (BedrockVersion.isNewVersion(pojo)) {
                if (pojo.getGeometryModelNew() != null) {
                    BedrockModel<EntityChair> bedrockModel = new BedrockModel<EntityChair>(pojo, BedrockVersion.NEW);
                    return bedrockModel;
                }
                TouhouLittleMaid.LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                BedrockModel<EntityChair> bedrockModel = null;
                return bedrockModel;
            }
            TouhouLittleMaid.LOGGER.warn(MARKER, "{} model version is not 1.10.0 or 1.12.0", (Object)modelLocation);
            return null;
        }
        catch (IOException ioe) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Failed to load model: {}", (Object)modelLocation);
            ioe.printStackTrace();
        }
        return null;
    }

    public static void registerFilePackTexture(Path rootPath, class_2960 texturePath) {
        FilePackTexture filePackTexture;
        if (!TMP_REGISTER_TEXTURE.contains(texturePath) && (filePackTexture = new FilePackTexture(rootPath, texturePath)).isExist()) {
            class_310.method_1551().method_1531().method_4616(texturePath, (class_1044)filePackTexture);
            TMP_REGISTER_TEXTURE.add(texturePath);
        }
    }

    public static void registerZipPackTexture(String zipFilePath, class_2960 texturePath) {
        ZipPackTexture zipPackTexture;
        if (!TMP_REGISTER_TEXTURE.contains(texturePath) && (zipPackTexture = new ZipPackTexture(zipFilePath, texturePath)).isExist()) {
            class_310.method_1551().method_1531().method_4616(texturePath, (class_1044)zipPackTexture);
            TMP_REGISTER_TEXTURE.add(texturePath);
        }
    }
}

